/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.Configuration;
import gui.sim.ConfigurationButton;
import gui.sim.ConfigurationSelectionEvent;
import gui.sim.ConfigurationSelectionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JPanel;

public class ConfigurationPane
extends JPanel
implements ActionListener {
    private Automaton automaton;
    private HashMap configurationToButtonMap = new HashMap();
    private HashSet selected = new HashSet();
    private transient HashSet selectionListeners = new HashSet();

    public ConfigurationPane(Automaton automaton) {
        this.automaton = automaton;
    }

    public void add(Configuration configuration) {
        this.add(configuration, 0);
    }

    public void add(Configuration configuration, int n) {
        if (this.contains(configuration)) {
            return;
        }
        ConfigurationButton configurationButton = new ConfigurationButton(configuration, n);
        this.configurationToButtonMap.put(configuration, configurationButton);
        this.add(configurationButton);
        configurationButton.addActionListener(this);
    }

    public int getState(Configuration configuration) {
        return ((ConfigurationButton)this.configurationToButtonMap.get((Object)configuration)).state;
    }

    public boolean contains(Configuration configuration) {
        return this.configurationToButtonMap.containsKey(configuration);
    }

    public void setReject(Configuration configuration) {
        ConfigurationButton configurationButton = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (configurationButton == null) {
            return;
        }
        if (configurationButton.state == 0) {
            configurationButton.setState(2);
        }
        configurationButton.doClick();
    }

    public void setFrozen(Configuration configuration) {
        ConfigurationButton configurationButton = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (configurationButton == null) {
            return;
        }
        if (configurationButton.state == 0) {
            configurationButton.setState(3);
        }
        configurationButton.doClick();
    }

    public void setFocused(Configuration configuration) {
        ConfigurationButton configurationButton = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (configurationButton == null) {
            return;
        }
        if (configurationButton.state == 0) {
            configurationButton.setState(4);
            configurationButton.doClick();
        }
    }

    public void defocus(Configuration configuration) {
        this.setNormal(configuration);
        Configuration configuration2 = configuration;
        configuration2.setFocused(false);
        while (configuration2.getParent() != null) {
            configuration2 = configuration2.getParent();
            configuration2.setFocused(false);
        }
    }

    public void setNormal(Configuration configuration) {
        ConfigurationButton configurationButton = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (configurationButton == null) {
            return;
        }
        if (configurationButton.state == 3) {
            configurationButton.setState(0);
        } else if (configurationButton.state == 4) {
            configurationButton.setState(0);
        }
        configurationButton.doClick();
    }

    public void remove(Configuration configuration) {
        Component component = (Component)this.configurationToButtonMap.remove(configuration);
        if (component == null) {
            return;
        }
        this.selected.remove(configuration);
        this.remove(component);
    }

    public void clear() {
        this.configurationToButtonMap.clear();
        this.selected.clear();
        super.removeAll();
    }

    public void deselectAll() {
        this.selected.clear();
    }

    public Configuration[] getSelected() {
        return this.selected.toArray(new Configuration[0]);
    }

    public Configuration[] getConfigurations() {
        return this.configurationToButtonMap.keySet().toArray(new Configuration[0]);
    }

    public Configuration[] getValidConfigurations() {
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        for (ConfigurationButton configurationButton : this.configurationToButtonMap.values()) {
            if (configurationButton.state != 0 && configurationButton.state != 4) continue;
            arrayList.add(configurationButton.getConfiguration());
        }
        return arrayList.toArray(new Configuration[0]);
    }

    public void clearFinal() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.configurationToButtonMap.values());
        for (ConfigurationButton configurationButton : arrayList) {
            if (configurationButton.state != 1 && configurationButton.state != 2) continue;
            this.remove(configurationButton.getConfiguration());
        }
    }

    public void clearThawed() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.configurationToButtonMap.values());
        for (ConfigurationButton configurationButton : arrayList) {
            if (configurationButton.state == 3) continue;
            this.remove(configurationButton.getConfiguration());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ConfigurationButton configurationButton = null;
        try {
            configurationButton = (ConfigurationButton)actionEvent.getSource();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        Configuration configuration = configurationButton.getConfiguration();
        if (!this.configurationToButtonMap.containsKey(configuration)) {
            return;
        }
        if (configurationButton.isSelected()) {
            this.selected.add(configuration);
        } else {
            this.selected.remove(configuration);
        }
        this.distributeSelectionEvent(new ConfigurationSelectionEvent(this));
    }

    public void addSelectionListener(ConfigurationSelectionListener configurationSelectionListener) {
        this.selectionListeners.add(configurationSelectionListener);
    }

    public void removeSelectionListener(ConfigurationSelectionListener configurationSelectionListener) {
        this.selectionListeners.remove(configurationSelectionListener);
    }

    void distributeSelectionEvent(ConfigurationSelectionEvent configurationSelectionEvent) {
        for (ConfigurationSelectionListener configurationSelectionListener : this.selectionListeners) {
            configurationSelectionListener.configurationSelectionChange(configurationSelectionEvent);
        }
    }
}

