/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.Configuration;
import gui.viewer.StateDrawer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.Icon;

public abstract class ConfigurationIcon
implements Icon {
    private Configuration configuration;
    private Automaton automaton;
    protected static final int STATE_RADIUS = 13;
    private static final StateDrawer STATE_DRAWER = new StateDrawer(13);
    private static final Point STATE_POINT = new Point(26, 13);
    private static final Point BB_POINT = new Point((int)(STATE_POINT.getX() * 3.5), (int)STATE_POINT.getY());
    protected static final Point RIGHT_STATE = new Point(39, 0);
    protected static final Point BELOW_STATE = new Point(0, 26);

    public ConfigurationIcon(Configuration configuration) {
        this.configuration = configuration;
        this.automaton = configuration.getCurrentState().getAutomaton();
    }

    @Override
    public int getIconWidth() {
        return 400;
    }

    @Override
    public int getIconHeight() {
        return 26;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n, n2);
        this.paintConfiguration(component, graphics2D, this.getIconWidth(), this.getIconHeight());
        graphics2D.translate(-n, -n2);
    }

    public void paintConfiguration(Component component, Graphics2D graphics2D, int n, int n2) {
        STATE_DRAWER.drawState(graphics2D, this.automaton, this.configuration.getCurrentState(), STATE_POINT);
    }
}

