/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import regular.ExpressionChangeEvent;
import regular.ExpressionChangeListener;
import regular.RegularExpression;

public class EditorPane
extends JPanel {
    private RegularExpression expression;
    private JTextField field = new JTextField("");
    private ExpressionChangeListener listener = new ExpressionChangeListener(){

        @Override
        public void expressionChanged(ExpressionChangeEvent expressionChangeEvent) {
            EditorPane.this.field.setText(expressionChangeEvent.getExpression().asString());
        }
    };
    private Reference ref = new WeakReference((Object)null){

        @Override
        public Object get() {
            return EditorPane.this.field.getText();
        }
    };

    public EditorPane(RegularExpression regularExpression) {
        this.expression = regularExpression;
        this.field.setText(regularExpression.asString());
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorPane.this.updateExpression();
            }
        });
        this.field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                EditorPane.this.updateExpression();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                EditorPane.this.updateExpression();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                EditorPane.this.updateExpression();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)new JLabel("Edit the regular expression below:"), gridBagConstraints);
        this.add((Component)this.field, gridBagConstraints);
    }

    private void updateExpression() {
        this.expression.change(this.ref);
    }
}

