/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.Transition;
import automata.fsa.FSATransition;
import gui.editor.Tool;
import gui.regular.REToFSAController;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class DeexpressionifyTransitionTool
extends Tool {
    private REToFSAController controller;

    public DeexpressionifyTransitionTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, REToFSAController rEToFSAController) {
        super(automatonPane, automatonDrawer);
        this.controller = rEToFSAController;
    }

    @Override
    public String getToolTip() {
        return "De-expressionify Transition";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/de-expressionify.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('d');
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Transition transition = this.getDrawer().transitionAtPoint(mouseEvent.getPoint());
        if (transition != null) {
            this.controller.transitionCheck((FSATransition)transition);
        }
    }
}

