/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.pumping.CompCFPumpingLemmaInputPane;
import gui.pumping.CompRegPumpingLemmaInputPane;
import gui.pumping.HumanCFPumpingLemmaInputPane;
import gui.pumping.HumanRegPumpingLemmaInputPane;
import gui.pumping.PumpingLemmaChooser;
import gui.pumping.PumpingLemmaInputPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import pumping.ContextFreePumpingLemma;
import pumping.PumpingLemma;
import pumping.RegularPumpingLemma;

public class PumpingLemmaChooserPane
extends JPanel {
    PumpingLemmaChooser myChooser;
    Environment myEnvironment;
    JRadioButton humanButton;
    JRadioButton computerButton;

    public PumpingLemmaChooserPane(PumpingLemmaChooser pumpingLemmaChooser, Environment environment) {
        super.setLayout(new BorderLayout());
        this.myChooser = pumpingLemmaChooser;
        this.myEnvironment = environment;
        this.init();
    }

    public Environment getEnvironment() {
        return this.myEnvironment;
    }

    private void init() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder("Then select a lemma."));
        this.add((Component)this.initRadioButtonPanel(), "North");
        for (int i = 0; i < this.myChooser.size(); ++i) {
            jPanel.add(this.addPumpingLemma(i));
        }
        this.add((Component)jPanel, "Center");
    }

    private JPanel initRadioButtonPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("First choose who makes the first move."));
        this.humanButton = new JRadioButton("You go first");
        this.computerButton = new JRadioButton("Computer goes first");
        buttonGroup.add(this.humanButton);
        buttonGroup.add(this.computerButton);
        this.humanButton.setSelected(true);
        jPanel.add((Component)this.humanButton, "West");
        jPanel.add((Component)this.computerButton, "Center");
        return jPanel;
    }

    private JPanel addPumpingLemma(int n) {
        PumpingLemma pumpingLemma = this.myChooser.get(n);
        JPanel jPanel = new JPanel(new BorderLayout());
        JEditorPane jEditorPane = new JEditorPane("text/html", "<html><body align=center><b><i>L</i> = {" + pumpingLemma.getHTMLTitle() + "}</b></body></html>");
        jEditorPane.setBackground(this.getBackground());
        jEditorPane.setDisabledTextColor(Color.BLACK);
        jEditorPane.setEnabled(false);
        jPanel.add((Component)jEditorPane, "Center");
        PumpingLemmaChooseButton pumpingLemmaChooseButton = new PumpingLemmaChooseButton(this.myChooser.get(n), this.myEnvironment, n);
        jPanel.add((Component)pumpingLemmaChooseButton, "East");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    private class PumpingLemmaChooseButton
    extends JButton {
        private Environment myEnvironment;
        private PumpingLemma myLemma;
        private int myIndex;

        public PumpingLemmaChooseButton(PumpingLemma pumpingLemma, Environment environment, int n) {
            super("Select");
            this.myEnvironment = environment;
            this.myLemma = pumpingLemma;
            this.myIndex = n;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PumpingLemmaChooserPane.this.myChooser.reset(PumpingLemmaChooseButton.this.myIndex);
                    PumpingLemmaChooserPane.this.myChooser.setCurrent(PumpingLemmaChooseButton.this.myIndex);
                    PumpingLemmaInputPane pumpingLemmaInputPane = null;
                    if (PumpingLemmaChooserPane.this.humanButton.isSelected()) {
                        if (PumpingLemmaChooseButton.this.myLemma instanceof RegularPumpingLemma) {
                            pumpingLemmaInputPane = new HumanRegPumpingLemmaInputPane((RegularPumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        } else if (PumpingLemmaChooseButton.this.myLemma instanceof ContextFreePumpingLemma) {
                            pumpingLemmaInputPane = new HumanCFPumpingLemmaInputPane((ContextFreePumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        }
                    } else if (PumpingLemmaChooserPane.this.computerButton.isSelected()) {
                        if (PumpingLemmaChooseButton.this.myLemma instanceof RegularPumpingLemma) {
                            pumpingLemmaInputPane = new CompRegPumpingLemmaInputPane((RegularPumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        } else if (PumpingLemmaChooseButton.this.myLemma instanceof ContextFreePumpingLemma) {
                            pumpingLemmaInputPane = new CompCFPumpingLemmaInputPane((ContextFreePumpingLemma)PumpingLemmaChooseButton.this.myLemma);
                        }
                    }
                    PumpingLemmaChooseButton.this.myEnvironment.add((Component)pumpingLemmaInputPane, "Pumping Lemma", new CriticalTag(){});
                    PumpingLemmaChooseButton.this.myEnvironment.setActive(pumpingLemmaInputPane);
                }
            });
        }
    }
}

