/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.MovingText;
import gui.pumping.Text;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Canvas
extends JPanel {
    private ArrayList myLabelText = new ArrayList();
    private ArrayList myInitialText = new ArrayList();
    private ArrayList myMovingText = new ArrayList();
    private ArrayList myFinalText = new ArrayList();
    private static final Point2D.Double FIRST_ROW = new Point2D.Double(40.0, 40.0);
    private static final Point2D.Double SECOND_ROW = new Point2D.Double(80.0, 80.0);
    private static final Dimension MIN_SIZE = new Dimension(300, 80);
    private JButton myStepButton;
    private JButton myRestartButton;
    private boolean wait = true;

    public Canvas() {
        super(new BorderLayout());
        this.setMinimumSize(MIN_SIZE);
        this.setPreferredSize(MIN_SIZE);
    }

    public void setRestartEnabled(boolean bl) {
        this.myRestartButton.setEnabled(bl);
    }

    public void start() {
        this.wait = false;
        this.getRootPane().repaint();
    }

    public void stop() {
        this.wait = true;
    }

    public void setStepButton(JButton jButton) {
        this.myStepButton = jButton;
    }

    public void setRestartButton(JButton jButton) {
        this.myRestartButton = jButton;
    }

    public void reset() {
        this.stop();
        this.myLabelText.clear();
        this.myInitialText.clear();
        this.myMovingText.clear();
        this.myFinalText.clear();
        this.myStepButton.setEnabled(false);
        this.myRestartButton.setEnabled(false);
    }

    public Text addText(String string, String string2) {
        Text text = this.addText(string);
        this.myLabelText.add(Text.getLabel(this.getGraphics(), text, string2));
        return text;
    }

    public Text addText(String string) {
        Text text;
        Point2D.Double double_;
        if (this.myInitialText.isEmpty()) {
            double_ = FIRST_ROW;
        } else {
            text = (Text)this.myInitialText.get(this.myInitialText.size() - 1);
            Point2D.Double double_2 = text.getPos();
            double_ = new Point2D.Double(((Point2D)double_2).getX() + text.getWidth(this.getGraphics()) + Text.SPACE.getWidth(this.getGraphics()), ((Point2D)double_2).getY());
        }
        text = new Text(string, double_);
        if (text.toString().length() == 0) {
            text = new Text(Text.SPACE.toString(), double_);
        }
        this.myInitialText.add(text);
        return text;
    }

    public void moveText(int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < this.myInitialText.size(); ++i) {
            Text text = (Text)this.myInitialText.get(i);
            for (int j = 0; j < nArray[i]; ++j) {
                if (text.toString().length() == 0 || text.toString().equals(Text.SPACE.toString())) continue;
                Point2D.Double double_ = this.myMovingText.isEmpty() ? SECOND_ROW : new Point2D.Double(Canvas.SECOND_ROW.x + d, Canvas.SECOND_ROW.y);
                d += text.getWidth(this.getGraphics()) + 2.0;
                MovingText movingText = new MovingText(text, (Point2D)double_);
                this.myMovingText.add(movingText);
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Text text;
        int n;
        for (n = 0; n < this.myLabelText.size(); ++n) {
            text = (Text)this.myLabelText.get(n);
            text.paint(graphics);
        }
        for (n = 0; n < this.myInitialText.size(); ++n) {
            text = (Text)this.myInitialText.get(n);
            text.paint(graphics);
        }
        for (n = 0; n < this.myFinalText.size(); ++n) {
            text = (Text)this.myFinalText.get(n);
            text.paint(graphics);
        }
        if (this.wait) {
            return;
        }
        this.myRestartButton.setEnabled(true);
        if (!this.myMovingText.isEmpty()) {
            MovingText movingText = (MovingText)this.myMovingText.get(0);
            if (movingText.move()) {
                this.myFinalText.add(movingText.finalText());
                for (int i = 0; i < this.myFinalText.size(); ++i) {
                    Text text2 = (Text)this.myFinalText.get(i);
                    text2.paint(graphics);
                }
                this.myMovingText.remove(0);
                if (this.myMovingText.isEmpty()) {
                    this.myStepButton.setEnabled(false);
                }
                return;
            }
            movingText.paint(graphics);
        }
        this.getRootPane().repaint();
    }
}

