/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.fsa.MinimizeTreeNode;
import gui.tree.DefaultNodeDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.tree.TreeNode;

public class MinimizeNodeDrawer
extends DefaultNodeDrawer {
    private HashMap labels = new HashMap();

    @Override
    public void draw(Graphics2D graphics2D, TreeNode treeNode) {
        graphics2D.fill(NODE_SHAPE);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        graphics2D.draw(NODE_SHAPE);
        MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)treeNode;
        graphics2D.setColor(color);
        this.drawBox(graphics2D, MinimizeNodeDrawer.getStateString(minimizeTreeNode), new Point2D.Float(0.0f, 0.0f));
        graphics2D.setColor(color);
        this.drawBox(graphics2D, minimizeTreeNode.getTerminal(), new Point2D.Float(0.0f, 20.0f));
        graphics2D.setColor(color);
        String string = this.getLabel(treeNode);
        if (string == null) {
            return;
        }
        this.drawBox(graphics2D, string, new Point2D.Float(0.0f, -20.0f));
        graphics2D.setColor(color);
    }

    private static String getStateString(MinimizeTreeNode minimizeTreeNode) {
        State[] stateArray = (State[])minimizeTreeNode.getUserObject();
        int[] nArray = new int[stateArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = stateArray[i].getID();
        }
        Arrays.sort(nArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setLabel(TreeNode treeNode, String string) {
        if (string == null) {
            this.labels.remove(treeNode);
        } else {
            this.labels.put(treeNode, string);
        }
    }

    public String getLabel(TreeNode treeNode) {
        return (String)this.labels.get(treeNode);
    }

    private void drawBox(Graphics2D graphics2D, String string, Point2D point2D) {
        if (string.equals("")) {
            return;
        }
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        double d = point2D.getX() - rectangle2D.getWidth() / 2.0;
        double d2 = point2D.getY() - rectangle2D.getY() - rectangle2D.getHeight() / 2.0;
        graphics2D.fillRect((int)d - 2, (int)(d2 + rectangle2D.getY()) - 2, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect((int)d - 2, (int)(d2 + rectangle2D.getY()) - 2, (int)rectangle2D.getWidth() + 4, (int)rectangle2D.getHeight() + 4);
        graphics2D.drawString(string, (float)d, (float)d2);
    }
}

