/*
 * Decompiled with CFR 0.152.
 */
package gui.lsystem;

import gui.transform.Matrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

class Turtle
implements Cloneable,
Serializable {
    public double distance = 15.0;
    public final Point2D position = new Point2D.Double(0.0, 0.0){

        @Override
        public void setLocation(double d, double d2) {
            Turtle.this.oldPosition.setLocation(this);
            super.setLocation(d, d2);
            Turtle.this.updateBounds();
        }
    };
    public final Point2D oldPosition = new Point2D.Double();
    public Rectangle2D bounds = null;
    public double lineWidth = 1.0;
    public double incrementWidth = 1.0;
    private Stroke stroke = null;
    public Color color = Color.black;
    public Color polygonColor = Color.red;
    public double hueChange = 10.0;
    public double angleChange = 15.0;
    public Map parametersToNumbers;
    public Matrix matrix = new Matrix();
    public static Map COLORS;

    public Turtle() {
        this.parametersToNumbers = new HashMap();
        this.setDistance(15.0);
        this.setAngleChange(15.0);
        this.setHueChange(10.0);
        this.setLineWidth(1.0);
        this.setLineIncrement(1.0);
        this.updateBounds();
    }

    public Turtle(Turtle turtle) {
        this.matrix = new Matrix(turtle.matrix);
        this.distance = turtle.distance;
        this.bounds = null;
        this.matrix.origin(this.position);
        this.lineWidth = turtle.lineWidth;
        this.incrementWidth = turtle.incrementWidth;
        this.color = turtle.color;
        this.polygonColor = turtle.polygonColor;
        this.hueChange = turtle.hueChange;
        this.angleChange = turtle.angleChange;
        this.parametersToNumbers = new HashMap(turtle.parametersToNumbers);
    }

    private final void updateBounds() {
        try {
            this.bounds.add(this.position);
        }
        catch (NullPointerException nullPointerException) {
            this.bounds = new Rectangle2D.Double(this.position.getX(), this.position.getY(), 0.0, 0.0);
        }
    }

    public final Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.updateBounds();
        }
        return this.bounds;
    }

    public final void updateBounds(Turtle turtle) {
        this.bounds.add(turtle.bounds);
    }

    public Object clone() {
        return new Turtle(this);
    }

    public final void turn(boolean bl) {
        this.turn(bl ? -this.angleChange : this.angleChange);
    }

    public final void turn(double d) {
        this.matrix.yaw(d);
    }

    public final void pitch(boolean bl) {
        this.pitch(bl ? this.angleChange : -this.angleChange);
    }

    public final void pitch(double d) {
        this.matrix.pitch(d);
    }

    public final void roll(boolean bl) {
        this.roll(bl ? -this.angleChange : this.angleChange);
    }

    public final void roll(double d) {
        this.matrix.roll(d);
    }

    public final double getAngleChange() {
        return this.angleChange;
    }

    public final void setAngleChange(double d) {
        this.angleChange = Math.IEEEremainder(d, 360.0);
        this.parametersToNumbers.put("angle", new Double(d));
    }

    public final void setDistance(double d) {
        this.distance = d;
        this.parametersToNumbers.put("distance", new Double(d));
    }

    public final void go(double d) {
        this.matrix.translate(0.0, -d, 0.0);
        this.matrix.origin(this.position);
    }

    public final void go(boolean bl) {
        this.go(bl ? this.distance : -this.distance);
    }

    public static Color colorForString(String string) {
        try {
            return (Color)Color.class.getField(string).get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Color color = (Color)COLORS.get(string);
        if (color != null) {
            return color;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            if (f < 0.0f || f > 255.0f || f2 < 0.0f || f2 > 255.0f || f3 < 0.0f || f3 > 255.0f) {
                return null;
            }
            if (f <= 1.0f && f2 <= 1.0f && f3 <= 1.0f) {
                return Color.getHSBColor(f, f2, f3);
            }
            return new Color((int)f, (int)f2, (int)f3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final void setColor(String string) {
        Color color = Turtle.colorForString(string);
        if (color == null) {
            throw new IllegalArgumentException("No color named " + string + " found!");
        }
        this.setColor(color);
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setPolygonColor(String string) {
        Color color = Turtle.colorForString(string);
        if (color == null) {
            throw new IllegalArgumentException("No color named " + string + " found!");
        }
        this.setPolygonColor(color);
    }

    public final void setPolygonColor(Color color) {
        this.polygonColor = color;
    }

    public final Color getPolygonColor() {
        return this.polygonColor;
    }

    public void setHueChange(double d) {
        this.hueChange = Math.IEEEremainder(d, 360.0);
        this.parametersToNumbers.put("hueChange", new Double(d));
    }

    public void changeHue(boolean bl) {
        this.changeHue(bl ? this.hueChange : -this.hueChange);
    }

    public void changeHue(double d) {
        float[] fArray = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        fArray[0] = fArray[0] + (float)d / 360.0f;
        this.setColor(Color.getHSBColor(fArray[0], fArray[1], fArray[2]));
    }

    public void changePolygonHue(boolean bl) {
        this.changePolygonHue(bl ? this.hueChange : -this.hueChange);
    }

    public void changePolygonHue(double d) {
        float[] fArray = Color.RGBtoHSB(this.polygonColor.getRed(), this.polygonColor.getGreen(), this.polygonColor.getBlue(), null);
        fArray[0] = fArray[0] + (float)d / 360.0f;
        this.setPolygonColor(Color.getHSBColor(fArray[0], fArray[1], fArray[2]));
    }

    public final void setLineIncrement(double d) {
        this.incrementWidth = d;
        this.parametersToNumbers.put("lineIncrement", new Double(d));
    }

    public final void changeLineWidth(boolean bl) {
        this.changeLineWidth(bl ? this.incrementWidth : -this.incrementWidth);
    }

    public final void changeLineWidth(double d) {
        this.setLineWidth(this.lineWidth + d);
        this.stroke = null;
    }

    public final void setLineWidth(double d) {
        this.lineWidth = d;
        this.parametersToNumbers.put("lineWidth", new Double(d));
        this.stroke = null;
    }

    public final double getLineWidth() {
        return this.lineWidth;
    }

    public final Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke((float)Math.max(0.0, this.getLineWidth()));
        }
        return this.stroke;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ " + super.toString());
        stringBuffer.append(", distance=" + this.distance);
        stringBuffer.append(", position=(" + this.position.getX() + "," + this.position.getY() + ")");
        stringBuffer.append(", lineWidth=" + this.lineWidth);
        stringBuffer.append(", incrementWidth=" + this.incrementWidth);
        stringBuffer.append(", angleChange=" + this.angleChange);
        stringBuffer.append(", color=" + this.color);
        stringBuffer.append(", polygonColor=" + this.polygonColor);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public Number valueOf(String string) {
        return Turtle.valueOf(string, this.parametersToNumbers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Number valueOf(String string, Map map) {
        Object object;
        string = string.replaceAll("-", " -");
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.ordinaryChar(47);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Integer n = new Integer(0);
        boolean bl = false;
        Character c = new Character('+');
        try {
            block7: while (streamTokenizer.nextToken() != -1) {
                switch (streamTokenizer.ttype) {
                    case -3: {
                        object = (Number)map.get(streamTokenizer.sval);
                        if (bl) {
                            arrayList.add(c);
                        }
                        bl = true;
                        arrayList.add(object == null ? n : object);
                        continue block7;
                    }
                    case -2: {
                        if (bl) {
                            arrayList.add(c);
                        }
                        bl = true;
                        arrayList.add(new Double(streamTokenizer.nval));
                        continue block7;
                    }
                    case 10: {
                        continue block7;
                    }
                }
                bl = false;
                arrayList.add(new Character((char)streamTokenizer.ttype));
            }
        }
        catch (IOException iOException) {
            return new Double(Double.NaN);
        }
        object = arrayList.iterator();
        return Turtle.valueOf(object);
    }

    private static Number valueOf(Iterator iterator) {
        Stack<Number> stack = new Stack<Number>();
        Stack<Character> stack2 = new Stack<Character>();
        stack.push(new Double(0.0));
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Number) {
                stack.push((Number)e);
                continue;
            }
            Character c = (Character)e;
            char c2 = c.charValue();
            if (c2 == ')') break;
            if (c2 == '(') {
                stack.push(Turtle.valueOf(iterator));
                continue;
            }
            while (!stack2.isEmpty()) {
                boolean bl = false;
                char c3 = ((Character)stack2.peek()).charValue();
                switch (c2) {
                    case '+': 
                    case '-': {
                        if (c3 == '-' || c3 == '+') {
                            bl = true;
                        }
                    }
                    case '*': 
                    case '/': {
                        if (c3 == '*' || c3 == '/') {
                            bl = true;
                        }
                    }
                    case '^': {
                        if (c3 != '^') break;
                        bl = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Bad operator " + c2);
                    }
                }
                if (!bl) break;
                double d = ((Number)stack.pop()).doubleValue();
                double d2 = ((Number)stack.pop()).doubleValue();
                stack2.pop();
                switch (c3) {
                    case '^': {
                        d2 = Math.pow(d2, d);
                        break;
                    }
                    case '*': {
                        d2 *= d;
                        break;
                    }
                    case '/': {
                        d2 /= d;
                        break;
                    }
                    case '+': {
                        d2 += d;
                        break;
                    }
                    case '-': {
                        d2 -= d;
                        break;
                    }
                }
                stack.push(new Double(d2));
            }
            stack2.push(c);
        }
        while (!stack2.isEmpty()) {
            char c = ((Character)stack2.pop()).charValue();
            double d = ((Number)stack.pop()).doubleValue();
            double d3 = ((Number)stack.pop()).doubleValue();
            switch (c) {
                case '^': {
                    d3 = Math.pow(d3, d);
                    break;
                }
                case '*': {
                    d3 *= d;
                    break;
                }
                case '/': {
                    d3 /= d;
                    break;
                }
                case '+': {
                    d3 += d;
                    break;
                }
                case '-': {
                    d3 -= d;
                    break;
                }
            }
            stack.push(new Double(d3));
        }
        return (Number)stack.pop();
    }

    public void assign(String string, String string2) {
        this.parametersToNumbers.put(string, this.valueOf(string2));
    }

    public Number get(String string) {
        return (Number)this.parametersToNumbers.get(string);
    }

    static {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        hashMap.put("dukeBlue", new Color(0, 0, 156));
        hashMap.put("brown", new Color(129, 0, 0));
        hashMap.put("oliveDrab", new Color(114, 93, 0));
        hashMap.put("darkOliveGreen", new Color(109, 111, 0));
        hashMap.put("orangeRed", new Color(252, 118, 0));
        hashMap.put("maroon", new Color(190, 0, 0));
        hashMap.put("forestGreen", new Color(0, 127, 0));
        hashMap.put("purple", new Color(209, 0, 255));
        hashMap.put("springGreen", new Color(193, 255, 157));
        hashMap.put("violetRed", new Color(210, 0, 205));
        hashMap.put("goldenrod", new Color(255, 214, 0));
        hashMap.put("darkOliveGreen2", new Color(10, 127, 0));
        COLORS = Collections.unmodifiableMap(hashMap);
    }
}

