/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.BruteParser;
import grammar.parse.BruteParserEvent;
import grammar.parse.BruteParserListener;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.BruteParsePane;
import gui.grammar.parse.UnrestrictedTreePanel;
import gui.sim.multiple.InputTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.Timer;

public class TMBruteParsePane
extends BruteParsePane {
    private Grammar myTrimmedGrammar;

    public TMBruteParsePane(GrammarEnvironment grammarEnvironment, Grammar grammar, Grammar grammar2, HashMap<String, String> hashMap, InputTableModel inputTableModel) {
        super(grammarEnvironment, grammar);
        this.treePanel = new UnrestrictedTreePanel(this, hashMap);
        this.initView();
        this.myTrimmedGrammar = grammar2;
        this.myTrimmedGrammar.setStartVariable("S");
        this.myModel = inputTableModel;
    }

    @Override
    protected JTable initParseTable() {
        return null;
    }

    @Override
    protected JPanel initInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)new JLabel("Input"), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.inputField, gridBagConstraints);
        this.inputField.addActionListener(this.startAction);
        jPanel2.add((Component)this.progress, gridBagConstraints);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.initInputToolbar(), "North");
        return jPanel;
    }

    @Override
    public void parseMultiple() {
        String[][] stringArray = this.myModel.getInputs();
        int n = 1;
        if (this.environment.myObjects != null) {
            n = this.environment.myObjects.size();
        }
        int n2 = stringArray.length / n;
        Grammar grammar = this.grammar;
        if (this.environment.myObjects != null) {
            grammar = (Grammar)this.environment.myObjects.get(0);
        }
        if (this.row < stringArray.length - 1) {
            ++this.row;
            if (this.row % n2 == 0 && this.environment.myObjects != null) {
                this.grammar = grammar = (Grammar)this.environment.myObjects.get(this.row / n2);
            }
            this.parser = BruteParser.get(this.myTrimmedGrammar, stringArray[this.row][0]);
            this.parseInput(stringArray[this.row][0], this.parser);
        }
    }

    @Override
    public void parseInput(String string, BruteParser bruteParser) {
        if (string.equals("")) {
            return;
        }
        if (bruteParser == null) {
            try {
                this.parser = BruteParser.get(this.myTrimmedGrammar, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, illegalArgumentException.getMessage(), "Bad Input", 0);
                return;
            }
        } else {
            this.parser = bruteParser;
        }
        final Timer timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TMBruteParsePane.this.parser == null) {
                    return;
                }
                String string = "Nodes generated: " + TMBruteParsePane.this.parser.getTotalNodeCount() + "(" + TMBruteParsePane.this.parser.getConsiderationNodeCount() + ")";
                TMBruteParsePane.this.progress.setText("Parser running.  " + string);
            }
        });
        this.parser.addBruteParserListener(new BruteParserListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bruteParserStateChange(BruteParserEvent bruteParserEvent) {
                BruteParser bruteParser = bruteParserEvent.getParser();
                synchronized (bruteParser) {
                    Object object;
                    String string = bruteParserEvent.getParser().getTotalNodeCount() + " nodes generated.";
                    String string2 = null;
                    switch (bruteParserEvent.getType()) {
                        case 0: {
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(true);
                            TMBruteParsePane.this.pauseResumeAction.putValue("Name", "Pause");
                            timer.start();
                            string2 = "Parser started.";
                            TMBruteParsePane.this.statusDisplay.setText(string2);
                            break;
                        }
                        case 3: {
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(false);
                            timer.stop();
                            string2 = "String rejected.";
                            if (TMBruteParsePane.this.myModel == null) break;
                            object = TMBruteParsePane.this.myModel.getInputs();
                            int n = 1;
                            if (TMBruteParsePane.this.environment.myObjects != null) {
                                n = TMBruteParsePane.this.environment.myObjects.size();
                            }
                            int n2 = ((String[][])object).length / n;
                            TMBruteParsePane.this.myModel.setResult(TMBruteParsePane.this.row, "Reject", null, TMBruteParsePane.this.environment.myTransducerStrings, TMBruteParsePane.this.row % n2 * 2);
                            TMBruteParsePane.this.parseMultiple();
                            break;
                        }
                        case 1: {
                            timer.stop();
                            TMBruteParsePane.this.pauseResumeAction.putValue("Name", "Resume");
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(true);
                            string2 = "Parser paused.";
                            TMBruteParsePane.this.statusDisplay.setText(string2);
                            break;
                        }
                        case 2: {
                            TMBruteParsePane.this.pauseResumeAction.setEnabled(false);
                            TMBruteParsePane.this.stepAction.setEnabled(true);
                            timer.stop();
                            string2 = "String accepted!";
                            if (TMBruteParsePane.this.myModel == null) break;
                            TMBruteParsePane.this.myModel.setResult(TMBruteParsePane.this.row, "Accept", null, TMBruteParsePane.this.environment.myTransducerStrings, TMBruteParsePane.this.row);
                            TMBruteParsePane.this.parseMultiple();
                        }
                    }
                    TMBruteParsePane.this.progress.setText(string2 + "  " + string);
                    if (TMBruteParsePane.this.parser.isFinished()) {
                        if (!bruteParserEvent.isAccept()) {
                            TMBruteParsePane.this.treePanel.setAnswer(null);
                            TMBruteParsePane.this.treePanel.repaint();
                            TMBruteParsePane.this.stepAction.setEnabled(false);
                            TMBruteParsePane.this.statusDisplay.setText("Try another string.");
                            return;
                        }
                        object = bruteParserEvent.getParser().getAnswer();
                        while ((object = object.getParent()) != null) {
                        }
                        TMBruteParsePane.this.statusDisplay.setText("Press step to show derivations.");
                        TMBruteParsePane.this.treePanel.setAnswer(bruteParserEvent.getParser().getAnswer());
                        TMBruteParsePane.this.treePanel.repaint();
                    }
                }
            }
        });
        this.parser.start();
    }

    @Override
    public void input(String string) {
        if (this.parser != null) {
            this.parser.pause();
        }
        this.parseInput(string, null);
    }

    @Override
    protected String[] getViewChoices() {
        return new String[]{"Noninverted Tree", "Derivation Table"};
    }

    @Override
    public boolean step() {
        boolean bl = false;
        if (this.treePanel.next()) {
            this.stepAction.setEnabled(false);
            bl = true;
        }
        this.treePanel.repaint();
        return bl;
    }

    @Override
    protected JComponent initTreePanel() {
        return this.treePanel;
    }
}

