/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import automata.State;
import automata.StatePlacer;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.graph.AutomatonGraph;
import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.GEMLayoutAlgorithm;
import grammar.Grammar;
import grammar.Production;
import grammar.parse.LRParseTable;
import grammar.parse.LRParseTableGenerator;
import grammar.parse.Operations;
import gui.editor.EditorPane;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.ItemSetChooser;
import gui.grammar.parse.LLParseDerivationController;
import gui.grammar.parse.LRParsePane;
import gui.grammar.parse.LRParseTableChooserPane;
import gui.grammar.parse.LRParseTableDerivationPane;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LRParseDerivationController
extends LLParseDerivationController {
    static final int BUILD_DFA = 2;
    static final int PARSE_TABLE = 3;
    static final int FINISHED = 4;
    private FiniteStateAutomaton dfa;
    private ItemSetChooser itemChooser;
    private Grammar augmented;
    private LRParseTableDerivationPane derivation;
    private Map stateToItems = new HashMap();
    private Map itemsToState = new HashMap();
    private LRParseTable targetParseTable;
    private LRParseTable userParseTable;
    private boolean doAll = false;
    private static final String GOTO_SYMBOL = "\u00b7";
    EditorPane editor = null;

    public LRParseDerivationController(Grammar grammar, Grammar grammar2, GrammarEnvironment grammarEnvironment, FirstFollowTable firstFollowTable, JLabel jLabel, FiniteStateAutomaton finiteStateAutomaton, LRParseTableDerivationPane lRParseTableDerivationPane) {
        super(grammar, grammarEnvironment, firstFollowTable, null, jLabel);
        this.augmented = grammar2;
        this.dfa = finiteStateAutomaton;
        this.derivation = lRParseTableDerivationPane;
        this.itemChooser = new ItemSetChooser(grammar2, firstFollowTable);
    }

    private Set initialGotoSet() {
        Set<Production> set = new HashSet<Production>();
        Production[] productionArray = this.augmented.getProductions();
        Production production = productionArray[0];
        production = new Production(production.getLHS(), GOTO_SYMBOL + production.getRHS());
        set.add(production);
        set = Operations.closure(this.augmented, set);
        return set;
    }

    private Set variablesWithEndFollow() {
        Map map = Operations.follow(this.grammar);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Map.Entry entry : map.entrySet()) {
            if (!((Set)entry.getValue()).contains("$")) continue;
            hashSet.add(entry.getKey());
        }
        hashSet.add(this.grammar.getStartVariable() + "'");
        return hashSet;
    }

    private boolean isFinalSet(Set set) {
        for (Production production : set) {
            if (!production.getRHS().endsWith(GOTO_SYMBOL)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean done() {
        switch (this.step) {
            case -1: 
            case 0: 
            case 1: {
                return super.done();
            }
            case 2: {
                State state;
                Set set;
                Iterator iterator = this.itemsToState.entrySet().iterator();
                SelectionDrawer selectionDrawer = (SelectionDrawer)this.editor.getDrawer();
                int n = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    set = (Set)entry.getKey();
                    state = (State)entry.getValue();
                    Transition[] transitionArray = this.dfa.getTransitionsFromState(state);
                    String[] stringArray = Operations.getCanGoto(set);
                    if (stringArray.length == transitionArray.length) continue;
                    selectionDrawer.addSelected(state);
                    ++n;
                }
                if (n != 0) {
                    this.editor.repaint();
                    JOptionPane.showMessageDialog(this.firstFollow, "The indicated states need more transitions.", "Set Not Fully Expanded", 0);
                    selectionDrawer.clearSelected();
                    this.editor.repaint();
                    return false;
                }
                for (Map.Entry entry : this.itemsToState.entrySet()) {
                    set = (Set)entry.getKey();
                    state = (State)entry.getValue();
                    boolean bl = this.isFinalSet(set);
                    if (!(bl ^ this.dfa.isFinalState(state))) continue;
                    selectionDrawer.addSelected(state);
                    ++n;
                }
                if (n != 0) {
                    this.editor.repaint();
                    JOptionPane.showMessageDialog(this.firstFollow, "The indicated states are either final and\nshouldn't be, or are nonfinal and should be.", "States in Wrong Finality", 0);
                    selectionDrawer.clearSelected();
                    this.editor.repaint();
                    return false;
                }
                return true;
            }
            case 3: {
                int n = this.targetParseTable.getRowCount();
                int n2 = this.targetParseTable.getColumnCount();
                LRParseTableChooserPane lRParseTableChooserPane = this.derivation.getParseTableView();
                try {
                    lRParseTableChooserPane.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                lRParseTableChooserPane.clearSelection();
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (this.targetParseTable.getValueAt(i, j).equals(this.userParseTable.getValueAt(i, j))) continue;
                        ++n3;
                        lRParseTableChooserPane.highlight(i, j);
                    }
                }
                if (n3 == 0) {
                    return true;
                }
                JOptionPane.showMessageDialog(this.firstFollow, "Highlighted cells are incorrect.", "Bad Parse Table", 0);
                lRParseTableChooserPane.dehighlight();
                return false;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
        return false;
    }

    @Override
    public void completeStep() {
        switch (this.step) {
            case 0: 
            case 1: {
                super.completeStep();
                break;
            }
            case 2: {
                this.completeDFA();
                this.nextStep();
                break;
            }
            case 3: {
                int n = this.targetParseTable.getRowCount();
                int n2 = this.targetParseTable.getColumnCount();
                LRParseTableChooserPane lRParseTableChooserPane = this.derivation.getParseTableView();
                lRParseTableChooserPane.clearSelection();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        this.userParseTable.setValueAt(this.targetParseTable.getValueAt(i, j), i, j);
                    }
                }
                this.nextStep();
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
                break;
            }
            default: {
                System.err.println("Complete step screwed up!  Step is " + this.step);
            }
        }
    }

    @Override
    public void completeSelected() {
        switch (this.step) {
            case 0: 
            case 1: {
                super.completeSelected();
                break;
            }
            case 2: {
                JOptionPane.showMessageDialog(this.firstFollow, "That request is invalid for this particular step.", "Nothing Selectable", 0);
                break;
            }
            case 3: {
                int n = this.targetParseTable.getRowCount();
                int n2 = this.targetParseTable.getColumnCount();
                LRParseTableChooserPane lRParseTableChooserPane = this.derivation.getParseTableView();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n3 = lRParseTableChooserPane.convertColumnIndexToView(j);
                        if (!lRParseTableChooserPane.isCellSelected(i, n3)) continue;
                        this.userParseTable.setValueAt(this.targetParseTable.getValueAt(i, j), i, j);
                    }
                }
                lRParseTableChooserPane.repaint();
            }
        }
    }

    private void completeDFA() {
        Object object;
        if (this.step != 2) {
            System.err.println("COMPLETE DFA CALLED AT WRONG TIME");
            return;
        }
        StatePlacer statePlacer = new StatePlacer();
        HashSet<State> hashSet = new HashSet<State>();
        State[] stateArray = this.dfa.getStates();
        HashSet<State> hashSet2 = new HashSet<State>(Arrays.asList(stateArray));
        while (stateArray.length != hashSet.size()) {
            for (int i = 0; i < stateArray.length; ++i) {
                if (hashSet.contains(stateArray[i])) continue;
                object = (Set)this.stateToItems.get(stateArray[i]);
                if (this.isFinalSet((Set)object)) {
                    this.dfa.addFinalState(stateArray[i]);
                } else {
                    this.dfa.removeFinalState(stateArray[i]);
                }
                Transition[] transitionArray = this.dfa.getTransitionsFromState(stateArray[i]);
                TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(Operations.getCanGoto((Set)object)));
                for (int j = 0; j < transitionArray.length; ++j) {
                    treeSet.remove(((FSATransition)transitionArray[j]).getLabel());
                }
                for (String string : treeSet) {
                    Cloneable cloneable;
                    Set set = Operations.goTo(this.augmented, (Set)object, string);
                    State state = (State)this.itemsToState.get(set);
                    if (state == null) {
                        cloneable = statePlacer.getPointForState(this.dfa);
                        state = this.dfa.createState((Point)cloneable);
                        Production[] productionArray = set.toArray(new Production[0]);
                        this.assignItemsToState(productionArray, state);
                    }
                    cloneable = new FSATransition(stateArray[i], state, string);
                    this.dfa.addTransition((Transition)cloneable);
                }
                hashSet.add(stateArray[i]);
            }
            stateArray = this.dfa.getStates();
        }
        GEMLayoutAlgorithm gEMLayoutAlgorithm = new GEMLayoutAlgorithm();
        object = new AutomatonGraph(this.dfa);
        ((LayoutAlgorithm)gEMLayoutAlgorithm).layout((Graph)object, hashSet2);
        ((AutomatonGraph)object).moveAutomatonStates();
    }

    @Override
    public void completeAll() {
        this.doAll = true;
        do {
            this.completeStep();
        } while (this.step != 4);
        this.doAll = false;
    }

    public void gotoGroup(State state, Point point, State state2) {
        Production[] productionArray;
        String string = JOptionPane.showInputDialog(this.firstFollow, (Object)"What is the grammar symbol for the transition?");
        if (string == null) {
            return;
        }
        Set set = (Set)this.stateToItems.get(state);
        Set set2 = Operations.goTo(this.augmented, set, string);
        if (set2.size() == 0) {
            JOptionPane.showMessageDialog(this.firstFollow, "That symbol is invalid for this state.", "Bad Symbol for Group", 0);
            return;
        }
        if (state2 != null) {
            productionArray = (Production[])this.stateToItems.get(state2);
            if (!((Object)set2).equals(productionArray)) {
                JOptionPane.showMessageDialog(this.firstFollow, "The symbol " + string + " can't join these two states.", "Bad Progression", 0);
                return;
            }
        } else {
            productionArray = this.itemChooser.getItemSet(set2, "Goto on " + string);
            if (productionArray == null) {
                return;
            }
            HashSet<Production> hashSet = new HashSet<Production>();
            for (int i = 0; i < productionArray.length; ++i) {
                hashSet.add(productionArray[i]);
            }
            state2 = (State)this.itemsToState.get(hashSet);
            if (state2 == null) {
                state2 = this.dfa.createState(point);
                this.assignItemsToState(productionArray, state2);
            }
        }
        productionArray = new FSATransition(state, state2, string);
        this.dfa.addTransition((Transition)productionArray);
    }

    @Override
    public boolean nextStep() {
        if (!this.done()) {
            return false;
        }
        ++this.step;
        switch (this.step) {
            case 0: {
                this.parseAction.setEnabled(false);
                this.firstFollow.getFFModel().setCanEditFirst(true);
                this.firstFollow.getFFModel().setCanEditFollow(false);
                this.directions.setText("Define FIRST sets.  ! is the lambda character.");
                break;
            }
            case 1: {
                this.firstFollow.getFFModel().setCanEditFirst(false);
                this.firstFollow.getFFModel().setCanEditFollow(true);
                this.directions.setText("Define FOLLOW sets.  $ is the end of string character.");
                break;
            }
            case 2: {
                Production[] productionArray;
                this.doSelectedAction.setEnabled(false);
                this.firstFollow.getFFModel().setCanEditFollow(false);
                int n = this.doAll ? 1 : JOptionPane.showConfirmDialog(this.firstFollow, "Masterfully done hero!  Now you must\ndefine the set of items for the intial DFA state.\nDo you want to define the initial set yourself?", "Initial Set Construction", 0);
                Set set = this.initialGotoSet();
                Production[] productionArray2 = productionArray = n == 0 ? null : set.toArray(new Production[0]);
                while (productionArray == null && (productionArray = this.itemChooser.getItemSet(set, "Initial Goto Set")) == null) {
                    JOptionPane.showMessageDialog(this.firstFollow, "The initial set MUST be created now.", "Initial Set Needed", 0);
                }
                State state = this.dfa.createState(new Point(60, 40));
                this.dfa.setInitialState(state);
                this.assignItemsToState(productionArray, state);
                this.directions.setText("Build the DFA.");
                break;
            }
            case 3: {
                this.doSelectedAction.setEnabled(true);
                this.targetParseTable = LRParseTableGenerator.generate(this.augmented, this.dfa, this.stateToItems, this.itemsToState, Operations.follow(this.grammar));
                this.userParseTable = new LRParseTable(this.augmented, this.dfa);
                this.derivation.moveDFA();
                this.derivation.setParseTable(this.userParseTable);
                this.directions.setText("Fill entries in parse table.");
                break;
            }
            case 4: {
                this.doSelectedAction.setEnabled(false);
                this.doStepAction.setEnabled(false);
                this.doAllAction.setEnabled(false);
                this.nextAction.setEnabled(false);
                this.parseAction.setEnabled(true);
                this.derivation.getParseTableView().shiftMode();
                this.directions.setText("Parse table complete.  Press \"parse\" to use it.");
            }
        }
        return true;
    }

    @Override
    public void parse() {
        LRParsePane lRParsePane = new LRParsePane(this.environment, this.augmented, this.userParseTable);
        this.environment.add((Component)lRParsePane, "SLR(1) Parsing");
        this.environment.setActive(lRParsePane);
    }

    private void assignItemsToState(Production[] productionArray, State state) {
        HashSet<Production> hashSet = new HashSet<Production>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < productionArray.length; ++i) {
            hashSet.add(productionArray[i]);
            if (i != 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(productionArray[i].toString());
        }
        state.setLabel(stringBuffer.toString());
        this.stateToItems.put(state, hashSet);
        this.itemsToState.put(hashSet, state);
    }
}

