/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.parse.LLParseTable;
import grammar.parse.LLParseTableGenerator;
import grammar.parse.Operations;
import gui.environment.GrammarEnvironment;
import gui.grammar.parse.FirstFollowModel;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.LLParsePane;
import gui.grammar.parse.LLParseTablePane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class LLParseDerivationController {
    GrammarEnvironment environment;
    FirstFollowTable firstFollow;
    private LLParseTablePane parseTable;
    JLabel directions;
    int step = -1;
    static final int FIRST_SETS = 0;
    static final int FOLLOW_SETS = 1;
    static final int PARSE_TABLE = 2;
    static final int FINISHED = 3;
    Map targetFirstSets;
    Map targetFollowSets;
    Grammar grammar;
    private LLParseTable targetParseTable;
    AbstractAction doSelectedAction = new AbstractAction("Do Selected"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LLParseDerivationController.this.completeSelected();
        }
    };
    AbstractAction doStepAction = new AbstractAction("Do Step"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LLParseDerivationController.this.completeStep();
        }
    };
    AbstractAction doAllAction = new AbstractAction("Do All"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LLParseDerivationController.this.completeAll();
        }
    };
    AbstractAction nextAction = new AbstractAction("Next"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LLParseDerivationController.this.nextStep();
        }
    };
    AbstractAction parseAction = new AbstractAction("Parse"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LLParseDerivationController.this.parse();
        }
    };

    public LLParseDerivationController(Grammar grammar, GrammarEnvironment grammarEnvironment, FirstFollowTable firstFollowTable, LLParseTablePane lLParseTablePane, JLabel jLabel) {
        this.environment = grammarEnvironment;
        this.firstFollow = firstFollowTable;
        this.parseTable = lLParseTablePane;
        this.directions = jLabel;
        this.grammar = grammar;
        this.targetFirstSets = Operations.first(grammar);
        this.targetFollowSets = Operations.follow(grammar);
        this.targetParseTable = LLParseTableGenerator.generate(grammar);
        this.nextStep();
    }

    boolean done() {
        switch (this.step) {
            case -1: {
                return true;
            }
            case 0: 
            case 1: {
                Map map = this.step == 0 ? this.targetFirstSets : this.targetFollowSets;
                int n = this.step == 0 ? 1 : 2;
                FirstFollowModel firstFollowModel = this.firstFollow.getFFModel();
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                int n2 = 0;
                for (int i = 0; i < firstFollowModel.getRowCount(); ++i) {
                    String string = (String)firstFollowModel.getValueAt(i, 0);
                    if (((Object)firstFollowModel.getSet(i, n)).equals(map.get(string))) continue;
                    this.firstFollow.highlight(i, n);
                    ++n2;
                }
                if (n2 == 0) {
                    return true;
                }
                this.firstFollow.clearSelection();
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                JOptionPane.showMessageDialog(this.parseTable, "Highlighted sets are incorrect.", "Bad Sets", 0);
                this.firstFollow.dehighlight();
                return false;
            }
            case 2: {
                LLParseTable lLParseTable = this.parseTable.getParseTable();
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                String[][] stringArray = lLParseTable.getDifferences(this.targetParseTable);
                if (stringArray.length == 0) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = lLParseTable.getRow(stringArray[i][0]);
                    int n3 = lLParseTable.getColumn(stringArray[i][1]);
                    this.parseTable.highlight(n, n3);
                }
                this.parseTable.clearSelection();
                JOptionPane.showMessageDialog(this.firstFollow, "Highlighted cells are incorrect.", "Bad Parse Table", 0);
                this.parseTable.dehighlight();
                return false;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
        return false;
    }

    public void completeStep() {
        switch (this.step) {
            case 0: 
            case 1: {
                Map map = this.step == 0 ? this.targetFirstSets : this.targetFollowSets;
                int n = this.step == 0 ? 1 : 2;
                FirstFollowModel firstFollowModel = this.firstFollow.getFFModel();
                for (int i = 0; i < firstFollowModel.getRowCount(); ++i) {
                    String string = (String)firstFollowModel.getValueAt(i, 0);
                    firstFollowModel.setSet((Set)map.get(string), i, n);
                }
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.firstFollow.repaint();
                this.nextStep();
                break;
            }
            case 2: {
                LLParseTable lLParseTable = this.parseTable.getParseTable();
                for (int i = 0; i < lLParseTable.getRowCount(); ++i) {
                    String string = (String)lLParseTable.getValueAt(i, 0);
                    for (int j = 1; j < lLParseTable.getColumnCount(); ++j) {
                        int n = this.parseTable.convertColumnIndexToView(j);
                        lLParseTable.setValueAt(this.targetParseTable.getValueAt(i, j), i, j);
                    }
                }
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.parseTable.repaint();
                this.nextStep();
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
    }

    public void completeSelected() {
        switch (this.step) {
            case 0: 
            case 1: {
                Map map = this.step == 0 ? this.targetFirstSets : this.targetFollowSets;
                int n = this.step == 0 ? 1 : 2;
                FirstFollowModel firstFollowModel = this.firstFollow.getFFModel();
                int n2 = this.firstFollow.convertColumnIndexToView(n);
                for (int i = 0; i < firstFollowModel.getColumnCount(); ++i) {
                    if (!this.firstFollow.isCellSelected(i, n2)) continue;
                    String string = (String)firstFollowModel.getValueAt(i, 0);
                    firstFollowModel.setSet((Set)map.get(string), i, n);
                }
                try {
                    this.firstFollow.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.firstFollow.repaint();
                break;
            }
            case 2: {
                LLParseTable lLParseTable = this.parseTable.getParseTable();
                for (int i = 0; i < lLParseTable.getRowCount(); ++i) {
                    String string = (String)lLParseTable.getValueAt(i, 0);
                    for (int j = 1; j < lLParseTable.getColumnCount(); ++j) {
                        int n = this.parseTable.convertColumnIndexToView(j);
                        if (!this.parseTable.isCellSelected(i, n)) continue;
                        lLParseTable.setValueAt(this.targetParseTable.getValueAt(i, j), i, j);
                    }
                }
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.parseTable.repaint();
                break;
            }
            case 3: {
                JOptionPane.showMessageDialog(this.firstFollow, "The parse table is complete.", "Finished", 0);
            }
        }
    }

    public void completeAll() {
        do {
            this.completeStep();
        } while (this.step != 3);
    }

    public void parse() {
        LLParsePane lLParsePane = new LLParsePane(this.environment, this.grammar, this.targetParseTable);
        this.environment.add((Component)lLParsePane, "LL(1) Parsing");
        this.environment.setActive(lLParsePane);
    }

    public boolean isLL1() {
        return Operations.isLL1(this.grammar);
    }

    public boolean nextStep() {
        if (!this.done()) {
            return false;
        }
        ++this.step;
        switch (this.step) {
            case 0: {
                this.parseAction.setEnabled(false);
                this.firstFollow.getFFModel().setCanEditFirst(true);
                this.firstFollow.getFFModel().setCanEditFollow(false);
                this.directions.setText("Define FIRST sets.  ! is the lambda character.");
                break;
            }
            case 1: {
                this.firstFollow.getFFModel().setCanEditFirst(false);
                this.firstFollow.getFFModel().setCanEditFollow(true);
                this.directions.setText("Define FOLLOW sets.  $ is the end of string character.");
                break;
            }
            case 2: {
                this.firstFollow.getFFModel().setCanEditFollow(false);
                this.directions.setText("Fill entries in parse table.  Use ! for a lambda entry.");
                break;
            }
            case 3: {
                try {
                    this.parseTable.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.doSelectedAction.setEnabled(false);
                this.doStepAction.setEnabled(false);
                this.doAllAction.setEnabled(false);
                this.nextAction.setEnabled(false);
                if (this.isLL1()) {
                    this.parseAction.setEnabled(true);
                    this.directions.setText("Parse table complete.  Press \"parse\" to use it.");
                    break;
                }
                this.directions.setText("Parse table complete, but has ambiguity.");
            }
        }
        return true;
    }
}

