/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import grammar.Grammar;
import grammar.Production;
import grammar.parse.Operations;
import gui.SuperMouseAdapter;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.ImmutableGrammarTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class ItemSetChooser {
    private final GrammarTableListener GTListener = new GrammarTableListener();
    private Component parent;
    private JPanel panel = new JPanel(new BorderLayout());
    private GrammarTable chooseTable;
    private GrammarTable choiceTable;
    private Set restricted = null;
    private Set alreadyChosen;
    private Grammar grammar;

    public ItemSetChooser(Grammar grammar, Component component) {
        this.grammar = grammar;
        this.parent = component;
        this.chooseTable = new GrammarTable(new ImmutableGrammarTableModel(grammar));
        this.chooseTable.addMouseListener(this.GTListener);
        this.choiceTable = new GrammarTable(new ImmutableGrammarTableModel());
        JScrollPane jScrollPane = new JScrollPane(this.chooseTable);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.panel.add((Component)jScrollPane, "West");
        jScrollPane = new JScrollPane(this.choiceTable);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.panel.add((Component)jScrollPane, "East");
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new AbstractAction("Closure"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemSetChooser.this.closure();
            }
        });
        jToolBar.add(new AbstractAction("Finish"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ItemSetChooser.this.finish();
            }
        });
        this.panel.add((Component)jToolBar, "North");
    }

    private void closure() {
        HashSet<Production> hashSet = new HashSet<Production>();
        GrammarTableModel grammarTableModel = this.choiceTable.getGrammarModel();
        for (int i = 0; i < grammarTableModel.getRowCount() - 1; ++i) {
            if (!this.choiceTable.isRowSelected(i)) continue;
            hashSet.add(grammarTableModel.getProduction(i));
        }
        if (hashSet.size() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Select an item (or items) in the right table.", "Nothing Selected", 0);
            return;
        }
        Set set = Operations.closure(this.grammar, hashSet);
        set.removeAll(this.alreadyChosen);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.addItem((Production)iterator.next());
        }
    }

    private void finish() {
        if (this.restricted == null) {
            JOptionPane.showMessageDialog(this.parent, "There is no one right answer in this case.", "Ambiguity", 0);
            return;
        }
        HashSet hashSet = new HashSet(this.restricted);
        hashSet.removeAll(this.alreadyChosen);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.addItem((Production)iterator.next());
        }
    }

    public Production[] getItemSet(Set set, String string) {
        ArrayList<Production> arrayList;
        this.restricted = set;
        this.choiceTable.setModel(new ImmutableGrammarTableModel());
        this.alreadyChosen = new HashSet();
        while (true) {
            HashSet hashSet;
            int n;
            if ((n = JOptionPane.showConfirmDialog(this.parent, this.panel, string, 2)) == 2) {
                return null;
            }
            arrayList = new ArrayList<Production>();
            GrammarTableModel grammarTableModel = this.choiceTable.getGrammarModel();
            for (int i = 0; i < grammarTableModel.getRowCount() - 1; ++i) {
                arrayList.add(grammarTableModel.getProduction(i));
            }
            if (set == null || ((Object)(hashSet = new HashSet(arrayList))).equals(set)) break;
            JOptionPane.showMessageDialog(this.parent, "Some items are missing!", "Items Missing", 0);
        }
        return arrayList.toArray(new Production[0]);
    }

    private void addItem(Production production) {
        if (this.restricted != null && !this.restricted.contains(production)) {
            JOptionPane.showMessageDialog(this.parent, production.toString() + " is not part of the set.", "Item not Desirable", 0);
            return;
        }
        if (this.alreadyChosen.contains(production)) {
            JOptionPane.showMessageDialog(this.parent, production.toString() + " is already chosen.", "Item Already Chosen", 0);
            return;
        }
        this.alreadyChosen.add(production);
        this.choiceTable.getGrammarModel().addProduction(production);
    }

    private class ItemMenuListener
    implements ActionListener {
        Production prod;

        public ItemMenuListener(Production production) {
            this.prod = production;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Production production = new Production(this.prod.getLHS(), string);
            ItemSetChooser.this.addItem(production);
        }
    }

    private class GrammarTableListener
    extends SuperMouseAdapter {
        private GrammarTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            GrammarTable grammarTable = (GrammarTable)mouseEvent.getSource();
            int n = grammarTable.rowAtPoint(point = mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            if (n == grammarTable.getGrammarModel().getRowCount() - 1) {
                return;
            }
            Production production = grammarTable.getGrammarModel().getProduction(n);
            Production[] productionArray = Operations.getItems(production);
            JPopupMenu jPopupMenu = new JPopupMenu();
            ItemMenuListener itemMenuListener = new ItemMenuListener(production);
            for (int i = 0; i < productionArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(productionArray[i].toString());
                jMenuItem.setActionCommand(productionArray[i].getRHS());
                jMenuItem.addActionListener(itemMenuListener);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(grammarTable, point.x, point.y);
        }
    }
}

