/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.State;
import automata.Transition;
import automata.turing.TuringMachine;
import automata.turing.TuringToGrammarConverter;
import grammar.ConvertedUnrestrictedGrammar;
import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import gui.environment.FrameFactory;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.GrammarCreationException;
import gui.viewer.SelectionDrawer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;

public class TuringConvertController
extends ConvertController {
    private TuringToGrammarConverter converter;
    private TuringMachine myTuringMachine;

    public TuringConvertController(ConvertPane convertPane, SelectionDrawer selectionDrawer, TuringMachine turingMachine) {
        super(convertPane, selectionDrawer, turingMachine);
        this.myTuringMachine = turingMachine;
        this.converter = new TuringToGrammarConverter();
        convertPane.getTable().getColumnModel().getColumn(0).setMinWidth(150);
        convertPane.getTable().getColumnModel().getColumn(0).setMaxWidth(250);
        this.fillMap();
    }

    @Override
    protected Production[] getProductions(State state) {
        if (this.myTuringMachine.isInitialState(state)) {
            Transition[] transitionArray = this.myTuringMachine.getTransitions();
            return this.converter.createProductionsForInit(state, transitionArray);
        }
        return new Production[0];
    }

    @Override
    protected Production[] getProductions(Transition transition) {
        return this.converter.createProductionsForTransition(transition, this.myTuringMachine.getFinalStates());
    }

    @Override
    protected ConvertedUnrestrictedGrammar getGrammar() {
        int n;
        int n2 = this.getModel().getRowCount();
        ConvertedUnrestrictedGrammar convertedUnrestrictedGrammar = new ConvertedUnrestrictedGrammar();
        convertedUnrestrictedGrammar.setStartVariable("S");
        ArrayList<Production> arrayList = new ArrayList<Production>();
        for (n = 0; n < n2; ++n) {
            Production production = this.getModel().getProduction(n);
            if (production == null) continue;
            arrayList.add(production);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Production production = (Production)object;
                Production production2 = (Production)object2;
                if ("S".equals(production.getLHS())) {
                    if (production.getLHS().equals(production2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if ("S".equals(production2.getLHS())) {
                    return 1;
                }
                return production2.getLHS().compareTo(production.getRHS());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        for (n = 0; n < arrayList.size(); ++n) {
            convertedUnrestrictedGrammar.addProduction((Production)arrayList.get(n));
        }
        return convertedUnrestrictedGrammar;
    }

    @Override
    public Grammar exportGrammar() {
        if (this.objectToProduction.keySet().size() != this.alreadyDone.size()) {
            this.highlightUntransformed();
            JOptionPane.showMessageDialog(this.convertPane, "Conversion unfinished!  Objects to convert are highlighted.", "Conversion Unfinished", 0);
            this.changeSelection();
            return null;
        }
        try {
            ConvertedUnrestrictedGrammar convertedUnrestrictedGrammar = this.getGrammar();
            ArrayList<Production> arrayList = new ArrayList<Production>();
            Production[] productionArray = convertedUnrestrictedGrammar.getProductions();
            for (int i = 0; i < productionArray.length; ++i) {
                arrayList.add(productionArray[i]);
            }
            Collections.sort(arrayList, new Comparator<Production>(){

                @Override
                public int compare(Production production, Production production2) {
                    if (production.getLHS().equals("S")) {
                        return -1;
                    }
                    return production.getRHS().length() - production2.getRHS().length();
                }
            });
            ConvertedUnrestrictedGrammar convertedUnrestrictedGrammar2 = new ConvertedUnrestrictedGrammar();
            for (int i = 0; i < productionArray.length; ++i) {
                productionArray[i] = (Production)arrayList.get(i);
            }
            convertedUnrestrictedGrammar2.setStartVariable("S");
            convertedUnrestrictedGrammar2.addProductions(productionArray);
            FrameFactory.createFrame((Serializable)convertedUnrestrictedGrammar2, 0);
            return convertedUnrestrictedGrammar2;
        }
        catch (GrammarCreationException grammarCreationException) {
            JOptionPane.showMessageDialog(this.convertPane, grammarCreationException.getMessage(), "Error", 0);
            return null;
        }
    }

    private Grammar trim(Production[] productionArray) {
        char c = 'A';
        for (int i = 0; i < productionArray.length; ++i) {
            String string = productionArray[i].getLHS();
            if (c == 'S' || c == 'T') {
                c = (char)(c + 1);
            }
            int n = string.indexOf("V(");
            while (n > -1) {
                int n2 = string.indexOf(")");
                String string2 = "";
                if (n + n2 + 1 > string.length()) {
                    string2 = string.substring(n, n + n2);
                    string = string.substring(0, n) + c;
                } else {
                    string2 = string.substring(n, n + n2 + 1);
                    string = string.substring(0, n) + c + string.substring(n + n2);
                }
                n = string.indexOf("V(");
                for (int j = 0; j < productionArray.length; ++j) {
                    String string3 = productionArray[j].getLHS();
                    String string4 = productionArray[j].getRHS();
                    int n3 = string3.indexOf(string2);
                    if (n3 > -1) {
                        string3 = string3.substring(0, n3) + "" + c + string3.substring(n3 + string2.length());
                    }
                    if ((n3 = string4.indexOf(string2)) > -1) {
                        string4 = string4.substring(0, n3) + "" + c + string4.substring(n3 + string2.length());
                    }
                    productionArray[j] = new Production(string3, string4);
                }
                c = (char)(c + '\u0001');
            }
        }
        UnrestrictedGrammar unrestrictedGrammar = new UnrestrictedGrammar();
        unrestrictedGrammar.addProductions(productionArray);
        return unrestrictedGrammar;
    }
}

