/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.CodecRegistry;
import file.XMLCodec;
import gui.action.NewAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FileChangeEvent;
import gui.environment.FileChangeListener;
import gui.environment.Profile;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;

public class Universe {
    private static Map environmentToFrame = new HashMap();
    private static Map fileToFrame = new HashMap();
    public static JFileChooser CHOOSER = null;
    private static int numberRegistered = 0;
    private static FileChangeListener FILE_LISTENER = new FileChangeListener(){

        @Override
        public void fileChanged(FileChangeEvent fileChangeEvent) {
            Environment environment;
            File file;
            File file2 = fileChangeEvent.getOldFile();
            EnvironmentFrame environmentFrame = Universe.frameForEnvironment((Environment)fileChangeEvent.getSource());
            if (file2 != null) {
                fileToFrame.remove(Universe.getPath(file2));
            }
            if ((file = (environment = (Environment)fileChangeEvent.getSource()).getFile()) == null) {
                return;
            }
            fileToFrame.put(Universe.getPath(file), environmentFrame);
        }
    };
    public static final CodecRegistry CODEC_REGISTRY = new CodecRegistry();
    public static Profile curProfile;

    private Universe() {
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static int registerFrame(EnvironmentFrame environmentFrame) {
        Environment environment = environmentFrame.getEnvironment();
        environmentToFrame.put(environment, environmentFrame);
        File file = environment.getFile();
        if (file != null) {
            fileToFrame.put(Universe.getPath(file), environmentFrame);
        }
        environment.addFileChangeListener(FILE_LISTENER);
        NewAction.hideNew();
        return ++numberRegistered;
    }

    public static void unregisterFrame(EnvironmentFrame environmentFrame) {
        try {
            fileToFrame.remove(Universe.getPath(environmentFrame.getEnvironment().getFile()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        environmentToFrame.remove(environmentFrame.getEnvironment());
        if (Universe.numberOfFrames() == 0) {
            NewAction.showNew();
        }
    }

    public static EnvironmentFrame frameForFile(File file) {
        if (file == null) {
            return null;
        }
        return (EnvironmentFrame)fileToFrame.get(Universe.getPath(file));
    }

    public static EnvironmentFrame frameForEnvironment(Environment environment) {
        return (EnvironmentFrame)environmentToFrame.get(environment);
    }

    public static EnvironmentFrame[] frames() {
        return environmentToFrame.values().toArray(new EnvironmentFrame[0]);
    }

    public static int numberOfFrames() {
        return environmentToFrame.size();
    }

    static {
        try {
            CHOOSER = new JFileChooser(System.getProperties().getProperty("user.dir"));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        XMLCodec xMLCodec = new XMLCodec();
        CODEC_REGISTRY.add(xMLCodec);
        curProfile = new Profile();
    }
}

