/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import automata.Automaton;
import automata.event.AutomataNoteEvent;
import automata.event.AutomataNoteListener;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import gui.editor.UndoKeeper;
import gui.environment.Environment;

public class AutomatonEnvironment
extends Environment {
    private UndoKeeper myKeeper;

    public AutomatonEnvironment(Automaton automaton) {
        super(automaton);
        Listener listener = new Listener();
        automaton.addStateListener(listener);
        automaton.addTransitionListener(listener);
        automaton.addNoteListener(listener);
        this.initUndoKeeper();
    }

    public Automaton getAutomaton() {
        return (Automaton)super.getObject();
    }

    public UndoKeeper getUndoKeeper() {
        return this.myKeeper;
    }

    public void initUndoKeeper() {
        this.myKeeper = new UndoKeeper(this.getAutomaton());
    }

    public void saveStatus() {
        this.myKeeper.saveStatus();
    }

    public void restoreStatus() {
        this.myKeeper.restoreStatus();
    }

    public boolean shouldPaint() {
        return this.myKeeper == null ? true : !this.myKeeper.sensitive;
    }

    public void setWait() {
        this.myKeeper.setWait();
    }

    public void redo() {
        this.myKeeper.redo();
    }

    private class Listener
    implements AutomataStateListener,
    AutomataTransitionListener,
    AutomataNoteListener {
        private Listener() {
        }

        @Override
        public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
            AutomatonEnvironment.this.setDirty();
        }

        @Override
        public void automataStateChange(AutomataStateEvent automataStateEvent) {
            AutomatonEnvironment.this.setDirty();
        }

        @Override
        public void automataNoteChange(AutomataNoteEvent automataNoteEvent) {
            AutomatonEnvironment.this.setDirty();
        }
    }
}

