/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import gui.editor.Tool;
import gui.editor.TransitionCreator;
import gui.environment.AutomatonEnvironment;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class TransitionTool
extends Tool {
    protected State first;
    protected Point hover;
    protected TransitionCreator creator;
    private static Stroke STROKE = new BasicStroke(2.4f);
    private static Color COLOR = new Color(0.5f, 0.5f, 0.5f, 0.5f);

    public TransitionTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, TransitionCreator transitionCreator) {
        super(automatonPane, automatonDrawer);
        this.creator = transitionCreator;
    }

    public TransitionTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
        super(automatonPane, automatonDrawer);
        this.creator = TransitionCreator.creatorForAutomaton(this.getAutomaton(), this.getView());
    }

    @Override
    public String getToolTip() {
        return "Transition Creator";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/transition.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
            ((AutomatonEnvironment)this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
        }
        this.first = this.getDrawer().stateAtPoint(mouseEvent.getPoint());
        if (this.first == null) {
            return;
        }
        this.hover = this.first.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        this.hover = mouseEvent.getPoint();
        this.getView().repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        State state = this.getDrawer().stateAtPoint(mouseEvent.getPoint());
        if (state != null) {
            this.creator.createTransition(this.first, state);
        }
        this.first = null;
        this.getView().repaint();
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.first == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE);
        graphics2D.setColor(COLOR);
        graphics2D.drawLine(this.first.getPoint().x, this.first.getPoint().y, this.hover.x, this.hover.y);
        graphics2D.setStroke(stroke);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('t');
    }
}

