/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import gui.editor.Tool;
import gui.environment.AutomatonEnvironment;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class StateTool
extends Tool {
    State state = null;

    public StateTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
        super(automatonPane, automatonDrawer);
    }

    @Override
    public String getToolTip() {
        return "State Creator";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/state.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getDrawer().getAutomaton().getEnvironmentFrame() != null) {
            ((AutomatonEnvironment)this.getDrawer().getAutomaton().getEnvironmentFrame().getEnvironment()).saveStatus();
        }
        this.state = this.getAutomaton().createState(mouseEvent.getPoint());
        this.getView().repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.state.setPoint(mouseEvent.getPoint());
        this.getView().repaint();
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('s');
    }
}

