/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import gui.editor.TableTransitionCreator;
import gui.viewer.AutomatonPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PDATransitionCreator
extends TableTransitionCreator {
    private static final String[] NAME = new String[]{"Read", "Pop", "Push"};

    public PDATransitionCreator(AutomatonPane automatonPane) {
        super(automatonPane);
    }

    @Override
    protected Transition initTransition(State state, State state2) {
        return new PDATransition(state, state2, "", "", "");
    }

    @Override
    protected TableModel createModel(Transition transition) {
        final PDATransition pDATransition = (PDATransition)transition;
        return new AbstractTableModel(){
            String[] s;
            {
                this.s = new String[]{pDATransition.getInputToRead(), pDATransition.getStringToPop(), pDATransition.getStringToPush()};
            }

            @Override
            public Object getValueAt(int n, int n2) {
                return this.s[n2];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                this.s[n2] = (String)object;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public int getRowCount() {
                return 1;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int n) {
                return NAME[n];
            }
        };
    }

    @Override
    public Transition modifyTransition(Transition transition, TableModel tableModel) {
        String string = (String)tableModel.getValueAt(0, 0);
        String string2 = (String)tableModel.getValueAt(0, 1);
        String string3 = (String)tableModel.getValueAt(0, 2);
        PDATransition pDATransition = (PDATransition)transition;
        try {
            return new PDATransition(pDATransition.getFromState(), pDATransition.getToState(), string, string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportException(illegalArgumentException);
            return null;
        }
    }
}

