/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.State;
import gui.deterministic.ConversionController;
import gui.editor.TransitionTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TransitionExpanderTool
extends TransitionTool {
    private ConversionController controller;

    public TransitionExpanderTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, ConversionController conversionController) {
        super(automatonPane, automatonDrawer);
        this.controller = conversionController;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        State state = this.getDrawer().stateAtPoint(mouseEvent.getPoint());
        this.controller.expandState(this.first, mouseEvent.getPoint(), state);
        this.first = null;
        this.getView().repaint();
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/expand_group.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public String getToolTip() {
        return "Expand Group on Terminal";
    }
}

