/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.State;
import gui.deterministic.ConversionController;
import gui.editor.Tool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class StateExpanderTool
extends Tool {
    private ConversionController controller;

    public StateExpanderTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, ConversionController conversionController) {
        super(automatonPane, automatonDrawer);
        this.controller = conversionController;
    }

    @Override
    public String getToolTip() {
        return "State Expander";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/state_expander.gif");
        return new ImageIcon(uRL);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        State state = this.getDrawer().stateAtPoint(mouseEvent.getPoint());
        if (state == null) {
            return;
        }
        this.controller.expandState(state);
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('s');
    }
}

