/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.fsa.FiniteStateAutomaton;
import gui.deterministic.AddTrapStateController;
import gui.deterministic.TrapStateTool;
import gui.deterministic.TrapTransitionTool;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBar;
import gui.editor.ToolBox;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AddTrapStatePane
extends JPanel {
    private AutomatonEnvironment myEnvironment;
    private FiniteStateAutomaton myAutomaton;

    public AddTrapStatePane(AutomatonEnvironment automatonEnvironment) {
        this.myAutomaton = (FiniteStateAutomaton)automatonEnvironment.getAutomaton().clone();
        EnvironmentFrame environmentFrame = Universe.frameForEnvironment(automatonEnvironment);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jLabel2, "South");
        this.add((Component)jPanel, "North");
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.myAutomaton);
        final AddTrapStateController addTrapStateController = new AddTrapStateController(this.myAutomaton, selectionDrawer, jLabel, jLabel2, environmentFrame);
        EditorPane editorPane = new EditorPane(selectionDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer));
                linkedList.add(new TrapStateTool(automatonPane, automatonDrawer, addTrapStateController));
                linkedList.add(new TrapTransitionTool(automatonPane, automatonDrawer, addTrapStateController));
                return linkedList;
            }
        });
        ToolBar toolBar = editorPane.getToolBar();
        toolBar.addSeparator();
        toolBar.add(new JButton(new AbstractAction("Do All"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                addTrapStateController.doAll();
            }
        }));
        this.add((Component)editorPane, "Center");
    }
}

