/*
 * Decompiled with CFR 0.152.
 */
package gui.deterministic;

import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.FrameFactory;
import gui.viewer.SelectionDrawer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class AddTrapStateController {
    private int currentStep = -1;
    private FiniteStateAutomaton automaton;
    private SelectionDrawer drawer;
    private JLabel mainStep;
    private JLabel detailStep;
    private JFrame frame;
    private int remaining = 0;
    private TreeSet<String> myReadSets;
    private HashMap<Integer, ArrayList<String>> myTransitionsMap;
    private HashMap<Integer, ArrayList<String>> myNeededTransitionMap;
    private HashMap<Integer, State> myStateMap;
    private State myTrapState;
    private static final int CREATE_SINGLE_TRAPSTATE = 0;
    private static final int TRANSITIONS_TO_TRAPSTATE = 1;
    private static final int FINISHED = 200;

    public AddTrapStateController(FiniteStateAutomaton finiteStateAutomaton, SelectionDrawer selectionDrawer, JLabel jLabel, JLabel jLabel2, JFrame jFrame) {
        this.automaton = finiteStateAutomaton;
        this.drawer = selectionDrawer;
        this.mainStep = jLabel;
        this.detailStep = jLabel2;
        this.frame = jFrame;
        this.currentStep = 0;
        this.nextStep();
    }

    private void nextStep() {
        switch (this.currentStep) {
            case 0: {
                this.currentStep = 0;
                this.mainStep.setText("Make Single Trap State");
                this.detailStep.setText("Create a new state to make a single trap state.");
                if (this.automaton.getFinalStates().length != 1 || this.automaton.getFinalStates()[0] == this.automaton.getInitialState()) {
                    return;
                }
                return;
            }
            case 1: {
                if (this.myReadSets == null) {
                    this.determineRemainingTransition();
                }
                this.mainStep.setText("Adding Transitions    Readable String : " + this.myReadSets);
                this.detailStep.setText("Put transitions from all states to the trap state.   " + this.remaining + " transitions must be added");
                if (this.drawer.numberSelected() != 0) {
                    return;
                }
                return;
            }
            case 200: {
                this.mainStep.setText("Adding a Trap State and Transitions is Finished!");
                this.detailStep.setText("");
                JOptionPane.showMessageDialog(this.frame, "The DFA is now complete!\nIt will now be placed in a new window.");
                FrameFactory.createFrame((FiniteStateAutomaton)this.automaton.clone());
                return;
            }
        }
    }

    private void determineRemainingTransition() {
        ArrayList<Object> arrayList;
        this.myTransitionsMap = new HashMap();
        this.myNeededTransitionMap = new HashMap();
        this.myReadSets = new TreeSet();
        this.myStateMap = new HashMap();
        State[] stateArray = this.automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            this.myTransitionsMap.put(stateArray[i].getID(), new ArrayList());
            this.myStateMap.put(stateArray[i].getID(), stateArray[i]);
        }
        Transition[] transitionArray = this.automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            this.myReadSets.add(transitionArray[i].getDescription());
            int n = transitionArray[i].getFromState().getID();
            arrayList = this.myTransitionsMap.get(n);
            arrayList.add(transitionArray[i].getDescription());
            this.myTransitionsMap.put(n, arrayList);
        }
        for (Integer n : this.myTransitionsMap.keySet()) {
            arrayList = new ArrayList();
            for (String string : this.myReadSets) {
                if (this.myTransitionsMap.get(n).contains(string)) continue;
                arrayList.add(string);
                ++this.remaining;
            }
            this.myNeededTransitionMap.put(n, arrayList);
        }
    }

    public void doAll() {
        switch (this.currentStep) {
            case 0: {
                JOptionPane.showMessageDialog(this.frame, "Just create a state.\nIt's not too difficult.", "Create the State", 0);
                return;
            }
        }
        for (Integer n : this.myNeededTransitionMap.keySet()) {
            ArrayList<String> arrayList = this.myNeededTransitionMap.get(n);
            for (String string : arrayList) {
                FSATransition fSATransition = new FSATransition(this.myStateMap.get(n), this.myTrapState, string);
                this.automaton.addTransition(fSATransition);
                this.frame.repaint();
            }
        }
        this.currentStep = 200;
        this.nextStep();
    }

    public State stateCreate(Point point) {
        if (this.currentStep != 0) {
            this.outOfOrder();
            return null;
        }
        this.myTrapState = this.automaton.createState(point);
        this.myTrapState.setLabel("Trap State");
        this.frame.repaint();
        this.currentStep = 1;
        this.nextStep();
        return this.myTrapState;
    }

    public void transitionCreate(State state, State state2) {
        if (this.currentStep != 1) {
            this.outOfOrder();
            return;
        }
        if (!state2.equals(this.myTrapState)) {
            JOptionPane.showMessageDialog(this.frame, "You have to make transition to the trap state!", "Error", 0);
            return;
        }
        String string = JOptionPane.showInputDialog(this.frame, (Object)"Transition on what terminal?");
        if (string == null) {
            return;
        }
        if (string.length() > 1) {
            JOptionPane.showMessageDialog(this.frame, "Terminal can only be a single letter", "Error", 0);
            return;
        }
        ArrayList<String> arrayList = this.myNeededTransitionMap.get(state.getID());
        if (arrayList.contains(string)) {
            FSATransition fSATransition = new FSATransition(state, state2, string);
            this.automaton.addTransition(fSATransition);
            this.frame.repaint();
            arrayList.remove(string);
            this.myNeededTransitionMap.put(state.getID(), arrayList);
            --this.remaining;
            if (this.remaining == 0) {
                this.currentStep = 200;
                this.nextStep();
                return;
            }
            this.detailStep.setText("Put transitions from all states to the trap state.   " + this.remaining + " transitions must be added");
            return;
        }
        if (!this.myReadSets.contains(string)) {
            JOptionPane.showMessageDialog(this.frame, "Terminal " + string + " is not part of readable string in DFA", "Incorrect input", 0);
        } else {
            JOptionPane.showMessageDialog(this.frame, "There is already a transition using Terminal " + string + " from this state", "Incorrect input", 0);
        }
    }

    protected void outOfOrder() {
        JOptionPane.showMessageDialog(this.frame, "That action is inappropriate for this step!", "Out of Order", 0);
    }
}

