/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.GrowableTableModel;
import gui.JTableExtender;
import gui.SplitPaneFactory;
import gui.action.MultipleSimulateAction;
import gui.action.TestAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Profile;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.GrammarInputPane;
import gui.grammar.parse.CYKParsePane;
import gui.sim.multiple.InputTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class MultipleCYKSimulateAction
extends MultipleSimulateAction {
    private Grammar myOriginalGrammar;
    private Grammar myCNFGrammar;
    private Environment myEnvironment;

    public MultipleCYKSimulateAction(Grammar grammar, Grammar grammar2, Environment environment) {
        super(grammar, environment);
        this.myOriginalGrammar = grammar;
        this.myEnvironment = environment;
        this.myCNFGrammar = grammar2;
    }

    @Override
    public void performAction(Component component) {
        Object object;
        this.table = this.initializeTable(this.getObject());
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            this.getEnvironment().remove(this.getEnvironment().getActive());
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        jPanel.add((Component)jToolBar, "South");
        jToolBar.add(new AbstractAction("Load Inputs"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MultipleCYKSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel inputTableModel = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                JFileChooser jFileChooser = new JFileChooser(System.getProperties().getProperty("user.dir"));
                int n = jFileChooser.showOpenDialog(null);
                File file = null;
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                    try {
                        Scanner scanner = new Scanner(file);
                        int n2 = inputTableModel.getRowCount() - 1;
                        while (scanner.hasNext()) {
                            String string = scanner.next();
                            inputTableModel.setValueAt(string, n2, 0);
                            ++n2;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                }
            }
        });
        jToolBar.add(new AbstractAction("Run Inputs"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MultipleCYKSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel inputTableModel = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                if (MultipleCYKSimulateAction.this.getObject() instanceof Grammar) {
                    String[][] stringArray = inputTableModel.getInputs();
                    int n = stringArray.length;
                    Grammar grammar = (Grammar)MultipleCYKSimulateAction.this.getObject();
                    CYKParsePane cYKParsePane = new CYKParsePane((GrammarEnvironment)MultipleCYKSimulateAction.this.getEnvironment(), MultipleCYKSimulateAction.this.myOriginalGrammar, MultipleCYKSimulateAction.this.myCNFGrammar, inputTableModel);
                    cYKParsePane.inputField.setEditable(false);
                    cYKParsePane.row = -1;
                    cYKParsePane.parseMultiple();
                }
            }
        });
        if (!((InputTableModel)this.table.getModel()).isMultiple) {
            jToolBar.add(new AbstractAction("Clear"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MultipleCYKSimulateAction.this.table.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    InputTableModel inputTableModel = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                    inputTableModel.clear();
                }
            });
            object = "Lambda";
            if (Universe.curProfile.getEmptyString().equals(Profile.LAMBDA)) {
                object = "Lambda";
            } else if (Universe.curProfile.getEmptyString().equals(Profile.EPSILON)) {
                object = "Epsilon";
            }
            jToolBar.add(new AbstractAction("Enter " + (String)object){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MultipleCYKSimulateAction.this.table.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    for (int i = 0; i < MultipleCYKSimulateAction.this.table.getColumnCount() - 1; ++i) {
                        MultipleCYKSimulateAction.this.table.getModel().setValueAt("", n, i);
                    }
                }
            });
        }
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            jToolBar.add(new AbstractAction("Edit File"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MultipleCYKSimulateAction.this.getMachineIndexBySelectedRow(MultipleCYKSimulateAction.this.table);
                    if (n >= 0 && n < MultipleCYKSimulateAction.this.getEnvironment().myObjects.size() && MultipleCYKSimulateAction.this.getObject() instanceof Grammar) {
                        Grammar grammar = (Grammar)MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(n);
                        GrammarInputPane grammarInputPane = new GrammarInputPane(grammar);
                        grammarInputPane.setName(grammar.getFileName());
                        MultipleCYKSimulateAction.this.getEnvironment().add((Component)grammarInputPane, "Edit", new CriticalTag(){});
                        MultipleCYKSimulateAction.this.getEnvironment().setActive(grammarInputPane);
                    }
                }
            });
            jToolBar.add(new AbstractAction("Add input string"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    Object object2;
                    boolean bl = true;
                    boolean bl2 = false;
                    if (MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(0) instanceof TuringMachine) {
                        bl2 = true;
                    }
                    if ((object2 = MultipleCYKSimulateAction.this.initialInput(MultipleCYKSimulateAction.this.getEnvironment().getActive(), "Input")) instanceof String) {
                        object = (String[])object2;
                        MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.add(object);
                    } else if (object2 instanceof String[]) {
                        object = (String[])object2;
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.add(object[i]);
                        }
                    } else {
                        return;
                    }
                    if (bl2) {
                        object = MultipleCYKSimulateAction.this.initialInput(MultipleCYKSimulateAction.this.getEnvironment().getActive(), "Expected Output?");
                        if (object instanceof String) {
                            String string = (String)object;
                            MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(string);
                        } else if (object instanceof String[]) {
                            Object object3 = object;
                            for (int i = 0; i < ((String[])object3).length; ++i) {
                                MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(object3[i]);
                            }
                        } else {
                            MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                            return;
                        }
                    }
                    if ((object = MultipleCYKSimulateAction.this.initialInput(MultipleCYKSimulateAction.this.getEnvironment().getActive(), "Expected Result? (Accept or Reject)")) instanceof String) {
                        String string = (String)object;
                        MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(string);
                    } else if (object instanceof String[]) {
                        Object object4 = object;
                        MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.add(object4[0]);
                    } else {
                        MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        MultipleCYKSimulateAction.this.getEnvironment().myTransducerStrings.remove(MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        return;
                    }
                    MultipleCYKSimulateAction.this.getEnvironment().remove(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                    MultipleCYKSimulateAction.this.performAction(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                }
            });
            jToolBar.add(new AbstractAction("Add file"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TestAction testAction = new TestAction();
                    testAction.chooseFile(MultipleCYKSimulateAction.this.getEnvironment().getActive(), false);
                    MultipleCYKSimulateAction.this.getEnvironment().remove(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                    MultipleCYKSimulateAction.this.performAction(MultipleCYKSimulateAction.this.getEnvironment().getActive());
                }
            });
            jToolBar.add(new AbstractAction("Remove file"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MultipleCYKSimulateAction.this.getMachineIndexBySelectedRow(MultipleCYKSimulateAction.this.table);
                    if (n >= 0 && n < MultipleCYKSimulateAction.this.getEnvironment().myObjects.size()) {
                        MultipleCYKSimulateAction.this.getEnvironment().myObjects.remove(n);
                        int n2 = MultipleCYKSimulateAction.this.table.getSelectedRow();
                        int n3 = MultipleCYKSimulateAction.this.getEnvironment().myObjects.size();
                        int n4 = MultipleCYKSimulateAction.this.getEnvironment().myTestStrings.size();
                        int n5 = n2 % n4;
                        int n6 = n2 - n5;
                        for (int i = 0; i < n4; ++i) {
                            ((InputTableModel)MultipleCYKSimulateAction.this.table.getModel()).deleteRow(n6);
                        }
                        MultipleCYKSimulateAction.this.table.changeSelection(0, 0, false, false);
                    }
                }
            });
            jToolBar.add(new AbstractAction("Save Results"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final JFrame jFrame = new JFrame("Save Location");
                    JRadioButton jRadioButton = new JRadioButton("Save Results with Original File");
                    jRadioButton.setMnemonic(66);
                    jRadioButton.setActionCommand("Save Results with Original File");
                    jRadioButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                    final JRadioButton jRadioButton2 = new JRadioButton("Specify New Location");
                    jRadioButton2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                    jRadioButton2.setMnemonic(67);
                    jRadioButton2.setActionCommand("Specify New Location");
                    jRadioButton.setSelected(true);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    buttonGroup.add(jRadioButton);
                    buttonGroup.add(jRadioButton2);
                    JPanel jPanel = new JPanel();
                    jPanel.add(jRadioButton);
                    jPanel.add(jRadioButton2);
                    jFrame.getContentPane().add((Component)jPanel, "Center");
                    JButton jButton = new JButton("Accept");
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n;
                            Serializable serializable;
                            jFrame.setVisible(false);
                            String string = "";
                            boolean bl = false;
                            if (jRadioButton2.isSelected()) {
                                serializable = null;
                                boolean bl2 = false;
                                while (bl2 || serializable == null) {
                                    if (bl2) continue;
                                    Universe.CHOOSER.setFileFilter(null);
                                    Universe.CHOOSER.setDialogTitle("Choose directory to save files in");
                                    Universe.CHOOSER.setFileSelectionMode(1);
                                    int n2 = Universe.CHOOSER.showSaveDialog(jFrame);
                                    if (n2 != 0) break;
                                    serializable = Universe.CHOOSER.getSelectedFile();
                                    try {
                                        string = ((File)serializable).getCanonicalPath();
                                        n = string.lastIndexOf("\\");
                                        if (n == -1) {
                                            string = string + "/";
                                            continue;
                                        }
                                        string = string + "\\";
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                            if (string.equals("")) {
                                bl = true;
                            }
                            serializable = (InputTableModel)MultipleCYKSimulateAction.this.table.getModel();
                            String string2 = (String)((GrowableTableModel)serializable).getValueAt(0, 0);
                            String string3 = (String)((GrowableTableModel)serializable).getValueAt(0, 0);
                            n = 0;
                            Object e = MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(0);
                            String string4 = string;
                            if (e instanceof Automaton) {
                                if (e instanceof TuringMachine) {
                                    n = 1;
                                }
                                if (bl) {
                                    string4 = ((Automaton)e).getFilePath();
                                }
                            } else if (e instanceof Grammar && bl) {
                                string4 = ((Grammar)e).getFilePath();
                            }
                            try {
                                FileWriter fileWriter = new FileWriter(string4 + "results" + string3 + ".txt");
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                PrintWriter printWriter = new PrintWriter(bufferedWriter);
                                for (int i = 0; i < ((GrowableTableModel)serializable).getRowCount(); ++i) {
                                    int n3;
                                    string3 = (String)((GrowableTableModel)serializable).getValueAt(i, 0);
                                    if (!string3.equals(string2)) {
                                        string2 = string3;
                                        printWriter.flush();
                                        printWriter.close();
                                        if (string3.equals("")) break;
                                        n3 = MultipleCYKSimulateAction.this.getMachineIndexByName(string3);
                                        e = MultipleCYKSimulateAction.this.getEnvironment().myObjects.get(n3);
                                        if (e instanceof Automaton) {
                                            if (!jRadioButton2.isSelected() || bl) {
                                                string4 = ((Automaton)e).getFilePath();
                                            }
                                        } else if (e instanceof Grammar && (!jRadioButton2.isSelected() || bl)) {
                                            string4 = ((Grammar)e).getFilePath();
                                        }
                                        bufferedWriter = new BufferedWriter(new FileWriter(string4 + "results" + string3 + ".txt"));
                                        printWriter = new PrintWriter(bufferedWriter);
                                    }
                                    n3 = 0;
                                    boolean bl3 = false;
                                    boolean bl4 = false;
                                    for (int j = 1; j < ((GrowableTableModel)serializable).getColumnCount(); ++j) {
                                        if (((InputTableModel)serializable).getColumnName(j).startsWith("Input") && n3 == 0) {
                                            printWriter.write("Input: ");
                                            n3 = 1;
                                        }
                                        if (((InputTableModel)serializable).getColumnName(j).startsWith("Output") && !bl4 && n != 0) {
                                            printWriter.write("Output: ");
                                            bl4 = true;
                                        }
                                        if (((InputTableModel)serializable).getColumnName(j).startsWith("Result")) {
                                            bl3 = true;
                                            printWriter.write("Result: ");
                                        }
                                        String string5 = (String)((GrowableTableModel)serializable).getValueAt(i, j);
                                        printWriter.write(string5 + " ");
                                        try {
                                            if (!bl3) continue;
                                            bufferedWriter.newLine();
                                            continue;
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                printWriter.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    jFrame.getContentPane().add((Component)jButton, "South");
                    jFrame.pack();
                    Point point = new Point(100, 50);
                    jFrame.setLocation(point);
                    jFrame.setVisible(true);
                }
            });
        }
        this.myPanel = jPanel;
        object = this.getObject();
        if (object instanceof Grammar) {
            CYKParsePane cYKParsePane = new CYKParsePane((GrammarEnvironment)this.getEnvironment(), (Grammar)object, this.myCNFGrammar, (InputTableModel)this.table.getModel());
            cYKParsePane.inputField.setEditable(false);
            if (this.getEnvironment().myTestStrings != null && this.getEnvironment().myTestStrings.size() > 0) {
                cYKParsePane.inputField.setText((String)this.getEnvironment().myTestStrings.get(0));
            }
            JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, cYKParsePane, jPanel);
            MultiplePane multiplePane = new MultiplePane(jSplitPane);
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(multiplePane);
        }
    }

    private int getMachineIndexBySelectedRow(JTable jTable) {
        InputTableModel inputTableModel = (InputTableModel)jTable.getModel();
        int n = jTable.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        String string = (String)inputTableModel.getValueAt(n, 0);
        return this.getMachineIndexByName(string);
    }

    @Override
    public int getMachineIndexByName(String string) {
        ArrayList arrayList = this.getEnvironment().myObjects;
        if (arrayList == null) {
            return -1;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Grammar grammar;
            Object e = arrayList.get(i);
            if (!(e instanceof Grammar) || !(grammar = (Grammar)e).getFileName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction((Component)actionEvent.getSource());
    }

    @Override
    protected void updateView(String string, String string2, JTableExtender jTableExtender) {
        ArrayList arrayList = this.getEnvironment().myObjects;
        Serializable serializable = null;
        serializable = arrayList != null ? (Serializable)arrayList.get(0) : this.getEnvironment().getObject();
        if (serializable instanceof Grammar && jTableExtender.getSelectedRow() < jTableExtender.getRowCount() - 1) {
            int n = this.getMachineIndexBySelectedRow(jTableExtender);
            Grammar grammar = null;
            grammar = n != -1 ? (Grammar)arrayList.get(n) : (Grammar)this.getEnvironment().getObject();
            CYKParsePane cYKParsePane = new CYKParsePane((GrammarEnvironment)this.getEnvironment(), grammar, this.myCNFGrammar, null);
            int n2 = 1;
            if (n == -1) {
                n2 = 0;
            }
            cYKParsePane.inputField.setText((String)jTableExtender.getModel().getValueAt(jTableExtender.getSelectedRow(), n2));
            cYKParsePane.inputField.setEditable(false);
            JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, cYKParsePane, this.myPanel);
            MultiplePane multiplePane = new MultiplePane(jSplitPane);
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.getEnvironment());
            String string3 = grammar.getFileName();
            if (string3 != "") {
                environmentFrame.setTitle(string3);
            }
            this.getEnvironment().remove(this.getEnvironment().getActive());
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(multiplePane);
        }
    }

    public class MultiplePane
    extends JPanel {
        public JSplitPane mySplit;

        public MultiplePane(JSplitPane jSplitPane) {
            super(new BorderLayout());
            this.mySplit = null;
            this.add((Component)jSplitPane, "Center");
            this.mySplit = jSplitPane;
        }
    }
}

