/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.Grammar;
import grammar.parse.Operations;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.parse.LLParseTableDerivationPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class LLParseTableAction
extends GrammarAction {
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;

    public LLParseTableAction(GrammarEnvironment grammarEnvironment) {
        super("Build LL(1) Parse Table", null);
        this.environment = grammarEnvironment;
        this.frame = Universe.frameForEnvironment(grammarEnvironment);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Grammar grammar = this.environment.getGrammar();
        if (grammar == null) {
            return;
        }
        if (!Operations.isLL1(grammar) && JOptionPane.showConfirmDialog(this.frame, "The grammar is not LL(1).\nContinue anyway?", "Grammar not LL(1)", 0) == 1) {
            return;
        }
        LLParseTableDerivationPane lLParseTableDerivationPane = new LLParseTableDerivationPane(this.environment);
        this.environment.add((Component)lLParseTableDerivationPane, "Build LL(1) Parse", new CriticalTag(){});
        this.environment.setActive(lLParseTableDerivationPane);
    }
}

