/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.UnrestrictedGrammar;
import gui.action.GrammarAction;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class GrammarTypeTestAction
extends GrammarAction {
    private GrammarEnvironment environment;
    private EnvironmentFrame frame;

    public GrammarTypeTestAction(GrammarEnvironment grammarEnvironment) {
        super("Test for Grammar Type", null);
        this.environment = grammarEnvironment;
        this.frame = Universe.frameForEnvironment(grammarEnvironment);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Grammar grammar = this.environment.getGrammar(UnrestrictedGrammar.class);
        if (grammar == null) {
            return;
        }
        Production[] productionArray = grammar.getProductions();
        boolean bl = this.checkforLinearity(productionArray);
        if (!bl && !this.isContextFreeGrammar(productionArray, grammar)) {
            this.checkForSpecialUnrestrictedGrammar(productionArray);
        }
    }

    private void checkForSpecialUnrestrictedGrammar(Production[] productionArray) {
        int n;
        int n2;
        Production[] productionArray2 = new Production[]{new Production("S", "V(==)S"), new Production("S", "SV(==)"), new Production("S", "T")};
        boolean[] blArray = new boolean[3];
        for (n2 = 0; n2 < productionArray.length; ++n2) {
            for (n = 0; n < productionArray2.length; ++n) {
                if (!productionArray[n2].getLHS().equals(productionArray2[n].getLHS()) || !productionArray[n2].getRHS().equals(productionArray2[n].getRHS())) continue;
                blArray[n2] = true;
            }
        }
        n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        if (n2 == blArray.length) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is an Unrestricted Grammar (converted from TM)", "Grammar Type", 1);
        } else {
            n = 0;
            for (int i = 0; i < productionArray.length; ++i) {
                if (productionArray[i].getLHS().length() > productionArray[i].getRHS().length()) continue;
                ++n;
            }
            if (n == productionArray.length) {
                JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a Context-Sensitive Grammar (also Unrestricted Grammar)", "Grammar Type", 1);
            } else {
                JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is an Unrestricted Grammar", "Grammar Type", 1);
            }
        }
    }

    private boolean isContextFreeGrammar(Production[] productionArray, Grammar grammar) {
        int n;
        int n2 = 0;
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isRestrictedOnLHS(productionArray[i])) continue;
            ++n2;
        }
        if (n2 != productionArray.length) {
            return false;
        }
        CNFConverter cNFConverter = null;
        cNFConverter = new CNFConverter(grammar);
        boolean bl = true;
        for (n = 0; n < productionArray.length; ++n) {
            bl &= cNFConverter.isChomsky(productionArray[n]);
        }
        if (bl) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a CNF Grammar (also Context-Free Grammar)", "Grammar Type", 1);
            return true;
        }
        n2 = 0;
        n = 1;
        for (int i = 0; i < productionArray.length; ++i) {
            if (productionArray[i].getRHS().length() == 0) {
                ++n2;
                continue;
            }
            char c = productionArray[i].getRHS().charAt(0);
            if (ProductionChecker.isTerminal(c)) {
                for (int j = 1; j < productionArray[i].getRHS().length(); ++j) {
                    if (ProductionChecker.isVariable(productionArray[i].getRHS().charAt(j))) continue;
                    n = 0;
                }
                continue;
            }
            n = 0;
        }
        if (n != 0) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a GNF Grammar (also Context-Free Grammar)", "Grammar Type", 1);
        } else {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a Context-Free Grammar", "Grammar Type", 1);
        }
        return true;
    }

    private boolean checkforLinearity(Production[] productionArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < productionArray.length; ++n) {
            if (!ProductionChecker.isRightLinear(productionArray[n])) continue;
            ++n2;
        }
        if (n2 == productionArray.length) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a right-linear Grammar (Regular Grammar and Context-Free Grammar)", "Grammar Type", 1);
            return true;
        }
        n2 = 0;
        for (n = 0; n < productionArray.length; ++n) {
            if (!ProductionChecker.isLeftLinear(productionArray[n])) continue;
            ++n2;
        }
        if (n2 == productionArray.length) {
            JOptionPane.showMessageDialog(this.environment.getComponent(0), "This is a left-linear Grammar (Regular Grammar and Context-Free Grammar)", "Grammar Type", 1);
            return true;
        }
        return false;
    }
}

