/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Transition;
import automata.graph.AutomatonGraph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.GEMLayoutAlgorithm;
import automata.pda.PushdownAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.cfg.CFGToPDALLConverter;
import gui.action.GrammarAction;
import gui.environment.GrammarEnvironment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.convert.ConvertPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class ConvertCFGLL
extends GrammarAction {
    private GrammarEnvironment environment;

    public ConvertCFGLL(GrammarEnvironment grammarEnvironment) {
        super("Convert CFG to PDA (LL)", null);
        this.environment = grammarEnvironment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Grammar grammar = this.environment.getGrammar();
        if (grammar == null) {
            return;
        }
        if (grammar.getProductions().length == 0) {
            JOptionPane.showMessageDialog(Universe.frameForEnvironment(this.environment), "The grammar should exist.");
            return;
        }
        PushdownAutomaton pushdownAutomaton = new PushdownAutomaton();
        CFGToPDALLConverter cFGToPDALLConverter = new CFGToPDALLConverter();
        cFGToPDALLConverter.createStatesForConversion(grammar, pushdownAutomaton);
        HashMap<Production, Transition> hashMap = new HashMap<Production, Transition>();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            hashMap.put(productionArray[i], cFGToPDALLConverter.getTransitionForProduction(productionArray[i]));
        }
        ConvertPane convertPane = new ConvertPane(grammar, pushdownAutomaton, hashMap, this.environment);
        this.environment.add((Component)convertPane, "Convert to PDA (LL)", new CriticalTag(){});
        AutomatonGraph automatonGraph = new AutomatonGraph(pushdownAutomaton);
        GEMLayoutAlgorithm gEMLayoutAlgorithm = new GEMLayoutAlgorithm();
        ((LayoutAlgorithm)gEMLayoutAlgorithm).layout(automatonGraph, null);
        automatonGraph.moveAutomatonStates();
        this.environment.setActive(convertPane);
        this.environment.validate();
        convertPane.getEditorPane().getAutomatonPane().fitToBounds(20);
    }
}

