/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.Production;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;

public class ParseNode
extends DefaultMutableTreeNode {
    private String derivation;
    private Production[] productions;
    private int[] subs;

    public ParseNode(String string, Production[] productionArray, int[] nArray) {
        this.derivation = string;
        if (productionArray.length != nArray.length) {
            throw new IllegalArgumentException("Production and substitution array sizes mismatch!");
        }
        this.productions = productionArray;
        this.subs = nArray;
    }

    public ParseNode(ParseNode parseNode) {
        this(parseNode.derivation, parseNode.productions, parseNode.subs);
    }

    public String getDerivation() {
        return this.derivation;
    }

    public Production[] getProductions() {
        return this.productions;
    }

    public int[] getSubstitutions() {
        return this.subs;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.derivation);
        stringBuffer.append(", ");
        stringBuffer.append(Arrays.asList(this.productions) + ", ");
        stringBuffer.append('[');
        for (int i = 0; i < this.subs.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.subs[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

