/*
 * Decompiled with CFR 0.152.
 */
package grammar.parse;

import grammar.CNFConverter;
import grammar.Grammar;
import grammar.LambdaProductionRemover;
import grammar.Production;
import grammar.UnitProductionRemover;
import grammar.UselessProductionRemover;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarInputPane;
import gui.grammar.transform.ChomskyPane;
import gui.grammar.transform.LambdaController;
import gui.grammar.transform.LambdaPane;
import gui.grammar.transform.UnitController;
import gui.grammar.transform.UnitPane;
import gui.grammar.transform.UselessController;
import gui.grammar.transform.UselessPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class CYKTracer {
    private Grammar myOriginalGrammar;
    private ArrayList<Production> myTrace;
    private ArrayList<Production> myAnswer;
    private Production[] myOriginalProductions;
    private HashMap<ArrayList<Production>, Production> myLambdaStepMap;
    private HashMap<ArrayList<Production>, Production> myUnitStepMap;
    private ArrayList<Production> myTempCNF;
    private HashMap<Production, ArrayList<Production>> myCNFMap;

    public CYKTracer(Grammar grammar, ArrayList<Production> arrayList) {
        this.myOriginalGrammar = grammar;
        this.myTrace = arrayList;
        this.myAnswer = new ArrayList();
        this.myOriginalProductions = this.myOriginalGrammar.getProductions();
        this.initializeLambdaStepMap();
    }

    private void initializeLambdaStepMap() {
        LambdaProductionRemover lambdaProductionRemover = new LambdaProductionRemover();
        HashSet hashSet = lambdaProductionRemover.getCompleteLambdaSet(this.myOriginalGrammar);
        Grammar grammar = this.myOriginalGrammar;
        if (hashSet.size() > 0) {
            ArrayList<Production> arrayList;
            int n;
            this.myLambdaStepMap = new HashMap();
            HashMap<String, Production> hashMap = new HashMap<String, Production>();
            HashMap hashMap2 = new HashMap();
            GrammarEnvironment grammarEnvironment = new GrammarEnvironment(new GrammarInputPane(this.myOriginalGrammar));
            LambdaPane lambdaPane = new LambdaPane(grammarEnvironment, this.myOriginalGrammar);
            LambdaController lambdaController = new LambdaController(lambdaPane, this.myOriginalGrammar);
            lambdaController.doStep();
            for (Object object : (HashSet)lambdaController.getLambdaSet()) {
                hashMap.put(((Production)object).getLHS(), (Production)object);
            }
            Production[] productionArray = lambdaPane.getGrammar().getProductions();
            for (Production[] productionArray2 : hashMap.keySet()) {
                for (n = 0; n < productionArray.length; ++n) {
                    if (!productionArray[n].getRHS().equals(productionArray2)) continue;
                    arrayList = new ArrayList<Production>();
                    arrayList.add(productionArray[n]);
                    arrayList.add((Production)hashMap.get(productionArray2));
                    hashMap2.put(productionArray[n].getLHS(), arrayList);
                }
            }
            for (int i = 0; i < productionArray.length; ++i) {
                Production[] productionArray2;
                productionArray2 = lambdaProductionRemover.getProductionsToAddForProduction(productionArray[i], hashSet);
                for (n = 0; n < productionArray2.length; ++n) {
                    arrayList = new ArrayList();
                    if (productionArray2[n].equals(productionArray[i])) continue;
                    arrayList.add(productionArray[i]);
                    ArrayList<String> arrayList2 = this.getDifferentVariable(productionArray[i].getRHS(), productionArray2[n].getRHS());
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        if (hashMap.keySet().contains(arrayList2.get(j))) {
                            arrayList.add((Production)hashMap.get(arrayList2.get(j)));
                            continue;
                        }
                        if (hashMap2.keySet().contains(arrayList2.get(j))) {
                            arrayList.addAll((Collection)hashMap2.get(arrayList2.get(j)));
                            continue;
                        }
                        this.reportError();
                    }
                    this.myLambdaStepMap.put(arrayList, productionArray2[n]);
                }
            }
            lambdaController.doAll();
            grammar = lambdaController.getGrammar();
        }
        this.intializeUnitStepMap(grammar);
    }

    private void intializeUnitStepMap(Grammar grammar) {
        UnitProductionRemover unitProductionRemover = new UnitProductionRemover();
        if (unitProductionRemover.getUnitProductions(grammar).length > 0) {
            int n;
            this.myUnitStepMap = new HashMap();
            GrammarEnvironment grammarEnvironment = new GrammarEnvironment(new GrammarInputPane(grammar));
            UnitPane unitPane = new UnitPane(grammarEnvironment, grammar);
            UnitController unitController = new UnitController(unitPane, grammar);
            unitController.doStep();
            Production[] productionArray = unitProductionRemover.getUnitProductions(grammar);
            HashMap<String, Production> hashMap = new HashMap<String, Production>();
            for (int i = 0; i < productionArray.length; ++i) {
                hashMap.put(productionArray[i].getLHS(), productionArray[i]);
            }
            Grammar grammar2 = unitProductionRemover.getUnitProductionlessGrammar(unitController.getGrammar(), unitProductionRemover.getVariableDependencyGraph(grammar));
            Production[] productionArray2 = grammar2.getProductions();
            ArrayList<Production> arrayList = new ArrayList<Production>();
            for (int i = 0; i < productionArray2.length; ++i) {
                arrayList.add(productionArray2[i]);
            }
            grammar = unitController.getGrammar();
            Production[] productionArray3 = grammar.getProductions();
            for (n = 0; n < productionArray3.length; ++n) {
                if (!arrayList.contains(productionArray3[n])) continue;
                arrayList.remove(productionArray3[n]);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                String string = ((Production)arrayList.get(n)).getLHS();
                if (hashMap.get(string) == null) {
                    this.reportError();
                } else {
                    String string2;
                    int n2;
                    arrayList2.add(hashMap.get(string));
                    String string3 = ((Production)hashMap.get(string)).getRHS();
                    boolean bl = false;
                    for (n2 = 0; n2 < productionArray3.length; ++n2) {
                        if (!productionArray3[n2].getLHS().equals(string3) || !(string2 = productionArray3[n2].getRHS()).equals(((Production)arrayList.get(n)).getRHS())) continue;
                        arrayList2.add(productionArray3[n2]);
                        bl = true;
                        break;
                    }
                    block5: while (!bl && hashMap.keySet().contains(string3)) {
                        arrayList2.add(hashMap.get(string3));
                        string3 = ((Production)hashMap.get(string3)).getRHS();
                        for (n2 = 0; n2 < productionArray3.length; ++n2) {
                            if (!productionArray3[n2].getLHS().equals(string3) || !(string2 = productionArray3[n2].getRHS()).equals(((Production)arrayList.get(n)).getRHS())) continue;
                            arrayList2.add(productionArray3[n2]);
                            bl = true;
                            continue block5;
                        }
                    }
                }
                this.myUnitStepMap.put((ArrayList<Production>)arrayList2, (Production)arrayList.get(n));
            }
            unitController.doAll();
            grammar = unitController.getGrammar();
        }
        this.removeUseless(grammar);
    }

    private void removeUseless(Grammar grammar) {
        Production[] productionArray;
        UselessProductionRemover uselessProductionRemover = new UselessProductionRemover();
        Grammar grammar2 = UselessProductionRemover.getUselessProductionlessGrammar(grammar);
        Production[] productionArray2 = grammar.getProductions();
        if (productionArray2.length > (productionArray = grammar2.getProductions()).length) {
            GrammarEnvironment grammarEnvironment = new GrammarEnvironment(new GrammarInputPane(grammar));
            UselessPane uselessPane = new UselessPane(grammarEnvironment, grammar);
            UselessController uselessController = new UselessController(uselessPane, grammar);
            uselessController.doAll();
            grammar = uselessController.getGrammar();
        }
        this.initializeChomskyMap(grammar);
    }

    private void initializeChomskyMap(Grammar grammar) {
        CNFConverter cNFConverter = new CNFConverter(grammar);
        Production[] productionArray = grammar.getProductions();
        boolean bl = true;
        for (int i = 0; i < productionArray.length; ++i) {
            bl &= cNFConverter.isChomsky(productionArray[i]);
        }
        if (!bl) {
            int n;
            Object object;
            this.myCNFMap = new HashMap();
            GrammarEnvironment grammarEnvironment = new GrammarEnvironment(new GrammarInputPane(grammar));
            ChomskyPane chomskyPane = new ChomskyPane(grammarEnvironment, grammar);
            ArrayList arrayList = new ArrayList();
            chomskyPane.doAll();
            for (int i = 0; i < productionArray.length; ++i) {
                this.myTempCNF = new ArrayList();
                object = new CNFConverter(grammar);
                this.convertToCNF((CNFConverter)object, productionArray[i]);
                this.myCNFMap.put(productionArray[i], this.myTempCNF);
                arrayList.addAll(this.myCNFMap.get(productionArray[i]));
            }
            Production[] productionArray2 = new Production[arrayList.size()];
            object = new HashMap();
            for (n = 0; n < productionArray2.length; ++n) {
                productionArray2[n] = (Production)arrayList.get(n);
            }
            productionArray2 = CNFConverter.convert(productionArray2);
            for (n = 0; n < productionArray2.length; ++n) {
                ((HashMap)object).put(arrayList.get(n), productionArray2[n]);
            }
            this.finalizeCNFMap((HashMap<Production, Production>)object);
            grammar = chomskyPane.getGrammar();
        }
    }

    private void finalizeCNFMap(HashMap<Production, Production> hashMap) {
        for (Production production : this.myCNFMap.keySet()) {
            ArrayList<Production> arrayList = new ArrayList<Production>();
            for (Production production2 : this.myCNFMap.get(production)) {
                arrayList.add(hashMap.get(production2));
            }
            this.myCNFMap.put(production, arrayList);
        }
    }

    private void convertToCNF(CNFConverter cNFConverter, Production production) {
        if (!cNFConverter.isChomsky(production)) {
            Production[] productionArray = cNFConverter.replacements(production);
            for (int i = 0; i < productionArray.length; ++i) {
                production = productionArray[i];
                this.convertToCNF(cNFConverter, production);
            }
        } else {
            this.myTempCNF.add(production);
        }
    }

    private ArrayList<String> getDifferentVariable(String string, String string2) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = 0;
        boolean bl = false;
        for (n = 0; n < cArray.length; ++n) {
            if (n2 == cArray2.length) {
                bl = true;
                break;
            }
            if (cArray[n] != cArray2[n2]) {
                arrayList.add("" + cArray[n]);
                --n2;
            }
            ++n2;
        }
        if (bl) {
            for (n = n2; n < cArray.length; ++n) {
                arrayList.add("" + cArray[n]);
            }
        }
        return arrayList;
    }

    public void traceBack() {
        this.backTrackToCNF();
        this.backTrackToUnit();
        this.backTrackToLambda();
        if (this.myAnswer.size() == 0) {
            this.myAnswer.addAll(this.myTrace);
        }
    }

    private void backTrackToCNF() {
        if (this.myCNFMap == null) {
            this.backTrackToUnit();
            return;
        }
        int[] nArray = new int[this.myTrace.size()];
        for (int i = 0; i < this.myTrace.size(); ++i) {
            if (nArray[i] != 0) continue;
            Production production = this.myTrace.get(i);
            if (this.myCNFMap.keySet().contains(production)) {
                this.myAnswer.add(production);
                nArray[i] = 1;
                continue;
            }
            for (Production production2 : this.myCNFMap.keySet()) {
                if (!this.myCNFMap.get(production2).contains(production)) continue;
                nArray = this.searchForRest(this.myCNFMap.get(production2), production2, nArray);
            }
        }
    }

    private int[] searchForRest(ArrayList<Production> arrayList, Production production, int[] nArray) {
        HashSet<Production> hashSet = new HashSet<Production>();
        int[] nArray2 = nArray;
        int n = 0;
        for (int i = 0; i < this.myTrace.size(); ++i) {
            if (!arrayList.contains(this.myTrace.get(i)) || nArray[i] != 0 || hashSet.contains(this.myTrace.get(i))) continue;
            nArray[i] = 1;
            hashSet.add(this.myTrace.get(i));
            ++n;
        }
        if (n == arrayList.size()) {
            this.myAnswer.add(production);
            return nArray;
        }
        return nArray2;
    }

    private void backTrackToUnit() {
        if (this.myUnitStepMap == null) {
            return;
        }
        for (int i = 0; i < this.myAnswer.size(); ++i) {
            for (ArrayList<Production> arrayList : this.myUnitStepMap.keySet()) {
                if (!this.myUnitStepMap.get(arrayList).equals(this.myAnswer.get(i))) continue;
                this.myAnswer.remove(i);
                int n = 0;
                for (Production production : arrayList) {
                    this.myAnswer.add(i + n, production);
                    ++n;
                }
                i = i + arrayList.size() - 1;
            }
        }
    }

    private void backTrackToLambda() {
        if (this.myLambdaStepMap == null) {
            return;
        }
        for (int i = 0; i < this.myAnswer.size(); ++i) {
            for (ArrayList<Production> arrayList : this.myLambdaStepMap.keySet()) {
                if (!this.myLambdaStepMap.get(arrayList).equals(this.myAnswer.get(i))) continue;
                this.myAnswer.remove(i);
                int n = 0;
                for (Production production : arrayList) {
                    this.myAnswer.add(i + n, production);
                    ++n;
                }
                i = i + arrayList.size() - 1;
            }
        }
    }

    public Production[] getAnswer() {
        Production[] productionArray = new Production[this.myAnswer.size()];
        for (int i = 0; i < this.myAnswer.size(); ++i) {
            productionArray[i] = this.myAnswer.get(i);
        }
        return productionArray;
    }

    private void reportError() {
    }
}

