/*
 * Decompiled with CFR 0.152.
 */
package grammar.lsystem;

import grammar.Grammar;
import grammar.Production;
import grammar.UnrestrictedGrammar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class LSystem
implements Serializable {
    private Map symbolToReplacements;
    private Map values;
    private List axiom;
    private boolean nondeterministic = false;
    private static final List[] EMPTY_LIST = new List[0];

    public LSystem() {
        this("", new UnrestrictedGrammar(), new HashMap());
    }

    public LSystem(String string, Grammar grammar, Map map) {
        this.values = Collections.unmodifiableMap(map);
        this.initReplacements(grammar);
        this.axiom = LSystem.tokenify(string);
    }

    public static List tokenify(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private void initReplacements(Grammar grammar) {
        Object object;
        List list;
        Object object2;
        List[] listArray;
        HashMap hashMap = new HashMap();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            listArray = productionArray[i].getLHS();
            object2 = null;
            if (!hashMap.containsKey(listArray)) {
                object2 = new ArrayList();
                hashMap.put(listArray, object2);
            } else {
                object2 = (ArrayList)hashMap.get(listArray);
            }
            list = LSystem.tokenify(productionArray[i].getRHS());
            try {
                object = (List)((ArrayList)object2).get(((ArrayList)object2).size() - 1);
                if (!((Object)list).equals(object)) {
                    this.nondeterministic = true;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ((ArrayList)object2).add(list);
        }
        Iterator iterator = hashMap.entrySet().iterator();
        this.symbolToReplacements = new TreeMap();
        listArray = new List[]{};
        while (iterator.hasNext()) {
            object2 = iterator.next();
            list = (List)object2.getValue();
            object = list.toArray(listArray);
            this.symbolToReplacements.put(object2.getKey(), object);
        }
    }

    public List getAxiom() {
        return this.axiom;
    }

    public List[] getReplacements(String string) {
        List[] listArray = (List[])this.symbolToReplacements.get(string);
        return listArray == null ? EMPTY_LIST : listArray;
    }

    public Set getSymbolsWithReplacements() {
        return this.symbolToReplacements.keySet();
    }

    public Map getValues() {
        return this.values;
    }

    public boolean nondeterministic() {
        return this.nondeterministic;
    }
}

