/*
 * Decompiled with CFR 0.152.
 */
package grammar.lsystem;

import grammar.lsystem.LSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Expander {
    private LSystem lsystem;
    private Random stochiastic;
    private List cachedExpansions = new ArrayList();
    private static final Random RANDOM = new Random();
    private Context[] contexts = null;
    protected static final List[] EMPTY_ARRAY = new List[0];

    public Expander(LSystem lSystem) {
        this(lSystem, RANDOM.nextLong());
    }

    public Expander(LSystem lSystem, long l) {
        this.stochiastic = new Random(l);
        this.lsystem = lSystem;
        this.cachedExpansions.add(lSystem.getAxiom());
        this.initializeContexts();
    }

    public List expansionForLevel(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Recursion level " + n + " impossible!");
        }
        if (n < this.cachedExpansions.size()) {
            return (List)this.cachedExpansions.get(n);
        }
        List list = (List)this.cachedExpansions.get(this.cachedExpansions.size() - 1);
        for (int i = this.cachedExpansions.size(); i <= n; ++i) {
            list = this.expand(list);
            this.cachedExpansions.add(list);
        }
        return list;
    }

    private List expand(List list) {
        if (this.contexts == null) {
            return this.expandNoContext(list);
        }
        return this.expandContext(list);
    }

    private List expandNoContext(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block4: for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            List[] listArray = this.lsystem.getReplacements(string);
            List list2 = null;
            switch (listArray.length) {
                case 0: {
                    arrayList.add(string);
                    continue block4;
                }
                case 1: {
                    list2 = listArray[0];
                    break;
                }
                default: {
                    list2 = listArray[this.stochiastic.nextInt(listArray.length)];
                }
            }
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
        }
        return arrayList;
    }

    private List expandContext(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block4: for (int i = 0; i < list.size(); ++i) {
            Object object;
            String string = (String)list.get(i);
            ArrayList<List> arrayList2 = new ArrayList<List>();
            for (int j = 0; j < this.contexts.length; ++j) {
                object = this.contexts[j].matches(list, i);
                for (int k = 0; k < ((List[])object).length; ++k) {
                    arrayList2.add(object[k]);
                }
            }
            List[] listArray = arrayList2.toArray(EMPTY_ARRAY);
            object = null;
            switch (listArray.length) {
                case 0: {
                    arrayList.add(string);
                    continue block4;
                }
                case 1: {
                    object = listArray[0];
                    break;
                }
                default: {
                    object = listArray[this.stochiastic.nextInt(listArray.length)];
                }
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
        }
        return arrayList;
    }

    private final void initializeContexts() {
        Iterator iterator = this.lsystem.getSymbolsWithReplacements().iterator();
        HashSet hashSet = new HashSet();
        Integer n = new Integer(1);
        ArrayList<Context> arrayList = new ArrayList<Context>();
        boolean bl = false;
        block7: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = LSystem.tokenify(string);
            List[] listArray = this.lsystem.getReplacements(string);
            int n2 = 0;
            switch (list.size()) {
                case 0: {
                    continue block7;
                }
                case 1: {
                    break;
                }
                default: {
                    try {
                        n2 = Integer.parseInt((String)list.get(0));
                        list.get(n2 + 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue block7;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        continue block7;
                    }
                    bl = true;
                    list = list.subList(1, list.size());
                }
            }
            arrayList.add(new Context(list, n2, listArray));
        }
        if (bl) {
            this.contexts = arrayList.toArray(new Context[0]);
        }
    }

    private class Context {
        protected List tokens;
        protected int center;
        protected List[] results;

        public Context(List list, int n, List[] listArray) {
            this.tokens = list;
            this.center = n;
            this.results = listArray;
        }

        public List[] matches(List list, int n) {
            n -= this.center;
            try {
                List list2 = list.subList(n, n + this.tokens.size());
                if (((Object)list2).equals(this.tokens)) {
                    return this.results;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return EMPTY_ARRAY;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" : tokens(");
            stringBuffer.append(this.tokens);
            stringBuffer.append(") at ");
            stringBuffer.append(this.center);
            stringBuffer.append(" with ");
            stringBuffer.append(Arrays.asList(this.results));
            return stringBuffer.toString();
        }
    }
}

