/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Production;

public class ProductionChecker {
    public static boolean isLinear(Production production) {
        return ProductionChecker.isRightLinear(production) || ProductionChecker.isLeftLinear(production);
    }

    public static boolean isRightLinear(Production production) {
        return ProductionChecker.isRightLinearProductionWithVariable(production) || ProductionChecker.isLinearProductionWithNoVariable(production);
    }

    public static boolean isLeftLinear(Production production) {
        return ProductionChecker.isLeftLinearProductionWithVariable(production) || ProductionChecker.isLinearProductionWithNoVariable(production);
    }

    public static boolean isLeftLinearProductionWithVariable(Production production) {
        char c;
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String string = production.getRHS();
        String[] stringArray = production.getVariablesOnRHS();
        return stringArray.length == 1 && ProductionChecker.isVariable(c = string.charAt(0));
    }

    public static boolean isRightLinearProductionWithVariable(Production production) {
        char c;
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String string = production.getRHS();
        String[] stringArray = production.getVariablesOnRHS();
        return stringArray.length == 1 && ProductionChecker.isVariable(c = string.charAt(string.length() - 1));
    }

    public static boolean isLinearProductionWithNoVariable(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String string = production.getRHS();
        String[] stringArray = production.getTerminalsOnRHS();
        return string.length() == stringArray.length;
    }

    public static boolean isUnitProduction(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String string = production.getRHS();
        String[] stringArray = production.getVariablesOnRHS();
        return string.length() == 1 && stringArray.length == 1;
    }

    public static boolean isLambdaProduction(Production production) {
        if (!ProductionChecker.isRestrictedOnLHS(production)) {
            return false;
        }
        String string = production.getRHS();
        return string.length() == 0;
    }

    public static boolean isRestrictedOnLHS(Production production) {
        String string = production.getLHS();
        String[] stringArray = production.getVariablesOnLHS();
        return string.length() == 1 && stringArray.length == 1;
    }

    public static boolean isVariableInProduction(String string, Production production) {
        String[] stringArray = production.getVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTerminalInProduction(String string, Production production) {
        String[] stringArray = production.getTerminals();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean areTerminalsOnRHS(Production production) {
        String string = production.getRHS();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!ProductionChecker.isTerminal(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVariable(char c) {
        return Character.isUpperCase(c);
    }

    public static boolean isTerminal(char c) {
        return !ProductionChecker.isVariable(c);
    }

    public static boolean isVariableOnRHS(Production production, String string) {
        String[] stringArray = production.getVariablesOnRHS();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

