/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.PumpingLemmaFactory;
import file.xml.PumpingLemmaTransducer;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pumping.RegularPumpingLemma;

public class RegPumpingLemmaTransducer
extends PumpingLemmaTransducer {
    public static String TYPE = "regular pumping lemma";
    public static String X_NAME = "xLength";
    public static String Y_NAME = "yLength";

    @Override
    public Serializable fromDOM(Document document) {
        int n;
        RegularPumpingLemma regularPumpingLemma = (RegularPumpingLemma)PumpingLemmaFactory.createPumpingLemma(TYPE, document.getElementsByTagName(LEMMA_NAME).item(0).getTextContent());
        regularPumpingLemma.setM(Integer.parseInt(document.getElementsByTagName(M_NAME).item(0).getTextContent()));
        regularPumpingLemma.setW(document.getElementsByTagName(W_NAME).item(0).getTextContent());
        regularPumpingLemma.setI(Integer.parseInt(document.getElementsByTagName(I_NAME).item(0).getTextContent()));
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(ATTEMPT);
        for (n = 0; n < nodeList.getLength(); ++n) {
            regularPumpingLemma.addAttempt(nodeList.item(n).getTextContent());
        }
        regularPumpingLemma.setFirstPlayer(document.getElementsByTagName(FIRST_PLAYER).item(0).getTextContent());
        n = Integer.parseInt(document.getElementsByTagName(X_NAME).item(0).getTextContent());
        int n2 = Integer.parseInt(document.getElementsByTagName(Y_NAME).item(0).getTextContent());
        regularPumpingLemma.setDecomposition(new int[]{n, n2});
        return regularPumpingLemma;
    }

    @Override
    public Document toDOM(Serializable serializable) {
        RegularPumpingLemma regularPumpingLemma = (RegularPumpingLemma)serializable;
        Document document = this.newEmptyDocument();
        Element element = document.getDocumentElement();
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, LEMMA_NAME, null, regularPumpingLemma.getTitle()));
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, FIRST_PLAYER, null, regularPumpingLemma.getFirstPlayer()));
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, M_NAME, null, "" + regularPumpingLemma.getM()));
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, W_NAME, null, "" + regularPumpingLemma.getW()));
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, I_NAME, null, "" + regularPumpingLemma.getI()));
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, X_NAME, null, "" + regularPumpingLemma.getX().length()));
        element.appendChild(RegPumpingLemmaTransducer.createElement(document, Y_NAME, null, "" + regularPumpingLemma.getY().length()));
        ArrayList arrayList = regularPumpingLemma.getAttempts();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                element.appendChild(RegPumpingLemmaTransducer.createElement(document, ATTEMPT, null, (String)arrayList.get(i)));
            }
        }
        return document;
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

