/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import file.DataException;
import file.xml.AutomatonTransducer;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PDATransducer
extends AutomatonTransducer {
    public static final String TRANSITION_READ_NAME = "read";
    public static final String TRANSITION_POP_NAME = "pop";
    public static final String TRANSITION_PUSH_NAME = "push";

    @Override
    protected Automaton createEmptyAutomaton(Document document) {
        return new PushdownAutomaton();
    }

    @Override
    protected Transition createTransition(State state, State state2, Node node, Map map, boolean bl) {
        String string = (String)map.get(TRANSITION_READ_NAME);
        String string2 = (String)map.get(TRANSITION_POP_NAME);
        String string3 = (String)map.get(TRANSITION_PUSH_NAME);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        try {
            return new PDATransition(state, state2, string, string2, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataException(illegalArgumentException.getMessage());
        }
    }

    @Override
    protected Element createTransitionElement(Document document, Transition transition) {
        Element element = super.createTransitionElement(document, transition);
        PDATransition pDATransition = (PDATransition)transition;
        element.appendChild(PDATransducer.createElement(document, TRANSITION_READ_NAME, null, pDATransition.getInputToRead()));
        element.appendChild(PDATransducer.createElement(document, TRANSITION_POP_NAME, null, pDATransition.getStringToPop()));
        element.appendChild(PDATransducer.createElement(document, TRANSITION_PUSH_NAME, null, pDATransition.getStringToPush()));
        return element;
    }

    @Override
    public String getType() {
        return "pda";
    }
}

