/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Codec;
import file.Encoder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodecRegistry {
    private List encoders = new ArrayList();
    private List decoders = new ArrayList();

    public void add(Codec codec) {
        this.addEncoder(codec);
        this.addDecoder(codec);
    }

    private void addEncoder(Encoder encoder) {
        this.encoders.add(encoder);
    }

    private void addDecoder(Encoder encoder) {
        this.decoders.add(encoder);
    }

    public List getEncoders(Serializable serializable) {
        if (serializable == null) {
            return Collections.unmodifiableList(this.encoders);
        }
        ArrayList<Codec> arrayList = new ArrayList<Codec>();
        for (Codec codec : this.encoders) {
            if (!codec.canEncode(serializable)) continue;
            arrayList.add(codec);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getDecoders() {
        return Collections.unmodifiableList(this.decoders);
    }
}

