/*
 * Decompiled with CFR 0.152.
 */
package automata.turing;

import java.io.Serializable;

public class Tape
implements Serializable {
    private StringBuffer buffer = new StringBuffer();
    private int tapeHead;
    private int cachedHash = -559038737;
    public static final char BLANK = '\u25a1';

    public Tape() {
        this("");
    }

    public Tape(String string) {
        this.buffer = new StringBuffer();
        if (string.equals("")) {
            string = "\u25a1";
        }
        this.buffer.insert(0, string);
        this.tapeHead = 0;
    }

    public Tape(Tape tape) {
        this.buffer = new StringBuffer(tape.buffer.toString());
        this.tapeHead = tape.getTapeHead();
        this.cachedHash = tape.cachedHash;
    }

    public void writeChar(char c) {
        this.buffer.deleteCharAt(this.tapeHead);
        this.buffer.insert(this.tapeHead, c);
        this.cachedHash = -559038737;
    }

    public void write(String string) {
        this.buffer.deleteCharAt(this.tapeHead);
        this.buffer.insert(this.tapeHead, string);
        this.cachedHash = -559038737;
    }

    public char readChar() {
        char[] cArray = new char[1];
        this.buffer.getChars(this.tapeHead, this.tapeHead + 1, cArray, 0);
        return cArray[0];
    }

    public String read() {
        char[] cArray = new char[1];
        this.buffer.getChars(this.tapeHead, this.tapeHead + 1, cArray, 0);
        return new String(cArray);
    }

    public void moveHead(String string) {
        try {
            switch (string.charAt(0)) {
                case 'L': {
                    --this.tapeHead;
                    break;
                }
                case 'R': {
                    ++this.tapeHead;
                    break;
                }
                case 'S': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tape direction " + string);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Tape direction is empty string!");
        }
        if (this.tapeHead >= this.buffer.length()) {
            int n = this.buffer.length();
            this.buffer.setLength(this.tapeHead + 1);
            for (int i = n; i < this.buffer.length(); ++i) {
                this.buffer.deleteCharAt(i);
                this.buffer.insert(i, '\u25a1');
            }
        } else if (this.tapeHead < 0) {
            int n = Math.abs(this.tapeHead);
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = 9633;
            }
            this.buffer.insert(0, cArray);
            this.tapeHead = 0;
        }
    }

    public String getContents() {
        return this.buffer.toString();
    }

    public String getOutput() {
        int n = this.buffer.indexOf("\u25a1", this.getTapeHead());
        if (n == -1) {
            n = this.buffer.length();
        }
        return this.buffer.substring(this.getTapeHead(), n);
    }

    public int getTapeHead() {
        return this.tapeHead;
    }

    public String toString() {
        return "[" + this.buffer.toString() + "]" + " TAPE HEAD AT " + this.tapeHead;
    }

    private void nonTrivial(int[] nArray) {
        int n;
        int n2;
        for (n2 = this.buffer.length() - 1; n2 > 0 && this.buffer.charAt(n2) == '\u25a1'; --n2) {
        }
        if (this.buffer.charAt(n2) != '\u25a1') {
            ++n2;
        }
        for (n = 0; n < n2 && this.buffer.charAt(n) == '\u25a1'; ++n) {
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    public boolean equals(Object object) {
        Tape tape;
        if (object == this) {
            return true;
        }
        try {
            tape = (Tape)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        this.nonTrivial(nArray);
        tape.nonTrivial(nArray2);
        if (nArray[1] - nArray[0] != nArray2[1] - nArray2[0]) {
            return false;
        }
        if (this.tapeHead - nArray[0] != tape.tapeHead - nArray2[0]) {
            return false;
        }
        while (nArray[0] < nArray[1]) {
            if (this.buffer.charAt(nArray[0]) != tape.buffer.charAt(nArray2[0])) {
                return false;
            }
            nArray[0] = nArray[0] + 1;
            nArray2[0] = nArray2[0] + 1;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHash != -559038737) {
            return this.cachedHash;
        }
        int[] nArray = new int[2];
        this.nonTrivial(nArray);
        this.cachedHash = this.buffer.substring(nArray[0], nArray[1]).hashCode();
        return this.cachedHash;
    }
}

