/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.LayoutAlgorithm;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class SpiralLayoutAlgorithm
extends LayoutAlgorithm {
    private Graph graph;

    public SpiralLayoutAlgorithm() {
    }

    public SpiralLayoutAlgorithm(Dimension dimension, Dimension dimension2, double d) {
        super(dimension, dimension2, d);
    }

    @Override
    public void layout(Graph graph, Set set) {
        this.graph = graph;
        ArrayList arrayList = SpiralLayoutAlgorithm.getMovableVertices(this.graph, set);
        if (this.graph == null || arrayList.size() == 0) {
            return;
        }
        VertexChain vertexChain = new VertexChain(this.graph);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                if (SpiralLayoutAlgorithm.this.graph.degree(object) == SpiralLayoutAlgorithm.this.graph.degree(object2)) {
                    return 0;
                }
                if (SpiralLayoutAlgorithm.this.graph.degree(object) > SpiralLayoutAlgorithm.this.graph.degree(object2)) {
                    return -1;
                }
                return 1;
            }
        });
        for (int i = 0; i < arrayList.size(); ++i) {
            vertexChain.addVertex(arrayList.get(i));
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.sqrt(Math.pow(this.vertexDim.getHeight(), 2.0) + Math.pow(this.vertexDim.getWidth(), 2.0)) + this.vertexBuffer;
        for (int i = 0; i < arrayList.size(); ++i) {
            d = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d3, 2.0));
            this.graph.moveVertex(vertexChain.get(i), new Point2D.Double(d, d2 += Math.asin(d3 / d)));
        }
        SpiralLayoutAlgorithm.polarToCartesian(this.graph, arrayList);
        SpiralLayoutAlgorithm.shiftOntoScreen(this.graph, this.size, this.vertexDim, true);
    }
}

