/*
 * Decompiled with CFR 0.152.
 */
package automata.graph.layout;

import automata.graph.Graph;
import automata.graph.layout.VertexChain;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class CircleChain
extends VertexChain {
    protected double radius = 0.0;
    protected Dimension vertexDim;
    protected double vertexBuffer;

    public CircleChain(Graph graph, Dimension dimension, double d) {
        super(graph);
        this.vertexDim = dimension;
        this.vertexBuffer = d;
    }

    public double getRadius() {
        return this.radius;
    }

    public void layoutInCircle() {
        this.layout(0.0, Math.PI, Math.PI * 2);
    }

    public void layout(double d, double d2, double d3) {
        double d4 = Math.sqrt(Math.pow(this.vertexDim.getHeight(), 2.0) + Math.pow(this.vertexDim.getWidth(), 2.0)) + this.vertexBuffer;
        if (this.size() == 0) {
            return;
        }
        if (this.size() == 1) {
            if (d == 0.0) {
                this.graph.moveVertex(this.vertices.get(0), new Point2D.Double(0.0, 0.0));
            } else {
                this.graph.moveVertex(this.vertices.get(0), new Point2D.Double(d + d4, d2));
            }
            return;
        }
        double d5 = d2 - d3 / 2.0;
        int n = Math.PI * 2 - d3 < 1.0E-4 ? this.size() : this.size() - 1;
        double d6 = d3 / (double)n;
        this.radius = d4 / d6;
        if (this.radius < d + d4) {
            this.radius = d + d4;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.graph.moveVertex(this.get(i), new Point2D.Double(this.radius, d5 + d6 * (double)i));
        }
    }
}

