/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import automata.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Set;

public abstract class LayoutAlgorithm {
    protected Dimension size;
    protected Dimension vertexDim;
    protected double vertexBuffer;

    public LayoutAlgorithm() {
        this.size = new Dimension(900, 900);
        this.vertexDim = new Dimension(30, 30);
        this.vertexBuffer = 30.0;
    }

    public LayoutAlgorithm(Dimension dimension, Dimension dimension2, double d) {
        this.size = dimension;
        this.vertexDim = dimension2;
        this.vertexBuffer = d;
    }

    public abstract void layout(Graph var1, Set var2);

    public static void shiftOntoScreen(Graph graph, Dimension dimension, Dimension dimension2, boolean bl) {
        int n;
        if (dimension == null || dimension.getHeight() == 0.0 || dimension.getWidth() == 0.0) {
            return;
        }
        Object[] objectArray = graph.vertices();
        double d = 2.147483647E9;
        double d2 = 2.147483647E9;
        double d3 = -2.147483648E9;
        double d4 = -2.147483648E9;
        for (n = 0; n < objectArray.length; ++n) {
            double d5 = graph.pointForVertex(objectArray[n]).getX();
            double d6 = graph.pointForVertex(objectArray[n]).getY();
            if (d5 < d) {
                d = d5;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            if (d6 < d2) {
                d2 = d6;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        for (n = 0; n < objectArray.length; ++n) {
            graph.moveVertex(objectArray[n], new Point2D.Double(graph.pointForVertex(objectArray[n]).getX() - d, graph.pointForVertex(objectArray[n]).getY() - d2));
        }
        double d7 = (d3 - d) / (dimension.getWidth() - 2.0 * dimension2.getWidth());
        double d8 = (d4 - d2) / (dimension.getHeight() - 2.0 * dimension2.getHeight());
        if (d7 > 1.0 || !bl) {
            for (n = 0; n < objectArray.length; ++n) {
                graph.moveVertex(objectArray[n], new Point2D.Double(graph.pointForVertex(objectArray[n]).getX() / d7, graph.pointForVertex(objectArray[n]).getY()));
            }
        }
        if (d8 > 1.0 || !bl) {
            for (n = 0; n < objectArray.length; ++n) {
                graph.moveVertex(objectArray[n], new Point2D.Double(graph.pointForVertex(objectArray[n]).getX(), graph.pointForVertex(objectArray[n]).getY() / d8));
            }
        }
        for (n = 0; n < objectArray.length; ++n) {
            graph.moveVertex(objectArray[n], new Point2D.Double(graph.pointForVertex(objectArray[n]).getX() + dimension2.getWidth(), graph.pointForVertex(objectArray[n]).getY() + dimension2.getHeight()));
        }
    }

    public static ArrayList getMovableVertices(Graph graph, Set set) {
        Object[] objectArray = graph.vertices();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (set != null && set.contains(objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    public static void cartesianToPolar(Graph graph, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Point2D point2D = graph.pointForVertex(arrayList.get(i));
            double d = point2D.getY() != 0.0 ? Math.atan(point2D.getY() / point2D.getX()) : 1.5707963267948966;
            double d2 = Math.sqrt(Math.pow(point2D.getX(), 2.0) + Math.pow(point2D.getY(), 2.0));
            graph.moveVertex(arrayList.get(i), new Point2D.Double(d2, d));
        }
    }

    public static void polarToCartesian(Graph graph, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Point2D point2D = graph.pointForVertex(arrayList.get(i));
            Point2D.Double double_ = new Point2D.Double(Math.cos(point2D.getY()) * point2D.getX(), Math.sin(point2D.getY()) * point2D.getX());
            graph.moveVertex(arrayList.get(i), double_);
        }
    }
}

