/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.State;
import java.awt.Point;
import java.io.Serializable;

public abstract class Transition
implements Serializable,
Cloneable {
    protected State from;
    protected State to;
    private Point myControlPoint;
    public boolean isSelected = false;

    public Transition(State state, State state2) {
        this.from = state;
        this.to = state2;
    }

    public abstract Transition copy(State var1, State var2);

    public Object clone() {
        Transition transition = this.copy(this.getFromState(), this.getToState());
        transition.isSelected = this.isSelected;
        transition.myControlPoint = this.myControlPoint == null ? null : new Point(this.myControlPoint);
        return transition;
    }

    public State getFromState() {
        return this.from;
    }

    public State getToState() {
        return this.to;
    }

    public void setFromState(State state) {
        this.from = state;
    }

    public void setToState(State state) {
        this.to = state;
    }

    public Automaton getAutomaton() {
        return this.from.getAutomaton();
    }

    public String getDescription() {
        return "";
    }

    public String toString() {
        return "[" + this.getFromState().toString() + "] -> [" + this.getToState().toString() + "]";
    }

    public boolean equals(Object object) {
        try {
            Transition transition = (Transition)object;
            return this.from == transition.from && this.to == transition.to;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.from.hashCode() ^ this.to.hashCode();
    }

    public int specialHash() {
        int n;
        int n2 = n = this.from == this.to ? this.from.specialHash() : this.from.specialHash() ^ this.to.specialHash();
        if (this.myControlPoint != null) {
            n ^= this.myControlPoint.hashCode();
        }
        return n;
    }

    public Point getControl() {
        return this.myControlPoint;
    }

    public void setControl(Point point) {
        this.myControlPoint = point;
    }
}

