/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.NondeterminismDetector;
import automata.fsa.FSANondeterminismDetector;
import automata.fsa.FiniteStateAutomaton;
import automata.mealy.MealyMachine;
import automata.mealy.MealyNondeterminismDetector;
import automata.pda.PDANondeterminismDetector;
import automata.pda.PushdownAutomaton;
import automata.turing.TMNondeterminismDetector;
import automata.turing.TuringMachine;

public class NondeterminismDetectorFactory {
    public static NondeterminismDetector getDetector(Automaton automaton) {
        if (automaton instanceof FiniteStateAutomaton) {
            return new FSANondeterminismDetector();
        }
        if (automaton instanceof PushdownAutomaton) {
            return new PDANondeterminismDetector();
        }
        if (automaton instanceof TuringMachine) {
            return new TMNondeterminismDetector();
        }
        if (automaton instanceof MealyMachine) {
            return new MealyNondeterminismDetector();
        }
        return null;
    }
}

