/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.State;

public abstract class Configuration
implements Cloneable {
    private boolean focused = false;
    private State myCurrentState;
    private Configuration parent;

    public Configuration(State state, Configuration configuration) {
        this.myCurrentState = state;
        this.parent = configuration;
    }

    public State getCurrentState() {
        return this.myCurrentState;
    }

    public void setCurrentState(State state) {
        this.myCurrentState = state;
    }

    public String toString() {
        return "[" + this.getCurrentState().toString() + "]";
    }

    public Configuration getParent() {
        return this.parent;
    }

    public abstract boolean isAccept();

    public boolean equals(Object object) {
        Configuration configuration = (Configuration)object;
        if (this.parent != configuration.parent) {
            return false;
        }
        return configuration.myCurrentState == this.myCurrentState;
    }

    public int hashCode() {
        return this.myCurrentState.hashCode() ^ (this.parent == null ? 0 : this.parent.primitiveHashCode());
    }

    private int primitiveHashCode() {
        return super.hashCode();
    }

    public boolean getFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public void reset() {
        this.setFocused(false);
    }
}

