﻿using CursoApi.Dtos;
using CursoApi.Models;
using Microsoft.EntityFrameworkCore;
using Newtonsoft.Json;

namespace CursoApi.Services
{
    public class WeatherForecastService : IWeatherForecastService
    {
        ApplicationContext _cx;

        public WeatherForecastService(ApplicationContext cx)
        {
            _cx = cx;
        }

        public async Task<WeatherForecastDto> Get(int propertyId)
        {
            var property = await _cx.RuralProperties.SingleAsync(x => x.Id == propertyId);

            var client = new HttpClient();
            var request = new HttpRequestMessage();
            request.Method = HttpMethod.Get;
            request.RequestUri = new Uri($"https://apiprevmet3.inmet.gov.br/previsao/{property.Ibge}");

            var response = await client.SendAsync(request);

            var json = await response.Content.ReadAsStringAsync();

            return Decode(property.Ibge, json);
        }

        private WeatherForecastDto Decode(string ibge, string json)
        {
            string today = DateTime.UtcNow.AddHours(-3).ToString("dd/MM/yyyy"); ;
            string tomorrow = DateTime.UtcNow.AddHours(-3).AddDays(1).ToString("dd/MM/yyyy");
            string todayPlus2 = DateTime.UtcNow.AddHours(-3).AddDays(2).ToString("dd/MM/yyyy");
            string todayPlus3 = DateTime.UtcNow.AddHours(-3).AddDays(3).ToString("dd/MM/yyyy");
            string todayPlus4 = DateTime.UtcNow.AddHours(-3).AddDays(4).ToString("dd/MM/yyyy");

            var result = JsonConvert.DeserializeObject<dynamic>(json);

            var dto = new WeatherForecastDto();
            dto.Days.Add(new WeatherForecastDayDto()
            {
                Date = today,
                Morning = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][today]["manha"]["resumo"],
                    Wind = result[ibge][today]["manha"]["int_vento"],
                    TemperatureMax = result[ibge][today]["manha"]["temp_max"],
                    TemperatureMin = result[ibge][today]["manha"]["temp_min"],
                },
                Afternoon = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][today]["tarde"]["resumo"],
                    Wind = result[ibge][today]["tarde"]["int_vento"],
                    TemperatureMax = result[ibge][today]["tarde"]["temp_max"],
                    TemperatureMin = result[ibge][today]["tarde"]["temp_min"],
                },
                Night = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][today]["noite"]["resumo"],
                    Wind = result[ibge][today]["noite"]["int_vento"],
                    TemperatureMax = result[ibge][today]["noite"]["temp_max"],
                    TemperatureMin = result[ibge][today]["noite"]["temp_min"],
                }
            });

            dto.Days.Add(new WeatherForecastDayDto()
            {
                Date = tomorrow,
                Morning = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][tomorrow]["manha"]["resumo"],
                    Wind = result[ibge][tomorrow]["manha"]["int_vento"],
                    TemperatureMax = result[ibge][tomorrow]["manha"]["temp_max"],
                    TemperatureMin = result[ibge][tomorrow]["manha"]["temp_min"],
                },
                Afternoon = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][tomorrow]["tarde"]["resumo"],
                    Wind = result[ibge][tomorrow]["tarde"]["int_vento"],
                    TemperatureMax = result[ibge][tomorrow]["tarde"]["temp_max"],
                    TemperatureMin = result[ibge][tomorrow]["tarde"]["temp_min"],
                },
                Night = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][tomorrow]["noite"]["resumo"],
                    Wind = result[ibge][tomorrow]["noite"]["int_vento"],
                    TemperatureMax = result[ibge][tomorrow]["noite"]["temp_max"],
                    TemperatureMin = result[ibge][tomorrow]["noite"]["temp_min"],
                }
            });

            dto.Days.Add(new WeatherForecastDayDto()
            {
                Date = todayPlus2,
                Data = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][todayPlus2]["resumo"],
                    Wind = result[ibge][todayPlus2]["int_vento"],
                    TemperatureMax = result[ibge][todayPlus2]["temp_max"],
                    TemperatureMin = result[ibge][todayPlus2]["temp_min"],
                }
            });

            dto.Days.Add(new WeatherForecastDayDto()
            {
                Date = todayPlus3,
                Data = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][todayPlus3]["resumo"],
                    Wind = result[ibge][todayPlus3]["int_vento"],
                    TemperatureMax = result[ibge][todayPlus3]["temp_max"],
                    TemperatureMin = result[ibge][todayPlus3]["temp_min"],
                }
            });

            dto.Days.Add(new WeatherForecastDayDto()
            {
                Date = todayPlus4,
                Data = new WeatherForecastDataDto()
                {
                    Summary = result[ibge][todayPlus4]["resumo"],
                    Wind = result[ibge][todayPlus4]["int_vento"],
                    TemperatureMax = result[ibge][todayPlus4]["temp_max"],
                    TemperatureMin = result[ibge][todayPlus4]["temp_min"],
                }
            });

            return dto;
        }
    }
}
