﻿using CursoApi.Dtos;
using CursoApi.Models;
using Microsoft.AspNetCore.Identity;

namespace CursoApi.Services
{
    public class UserService : IUserService
    {
        ApplicationContext _cx;
        UserManager<IdentityUser> _userManager;

        public UserService(ApplicationContext cx, Microsoft.AspNetCore.Identity.UserManager<IdentityUser> userManager)
        {
            _cx = cx;
            _userManager = userManager;
        }

        public async Task<bool> Insert(UserDto dto)
        {
            try
            {
                await _cx.Database.BeginTransactionAsync();

                var result = await _userManager.CreateAsync(new IdentityUser()
                {
                    Email = dto.Email,
                    UserName = dto.UserName
                }, dto.Password);

                if (!result.Succeeded) { 
                    return false;
                }
                    
                var user = _userManager.Users.First(x => x.UserName == dto.UserName);

                Tenant tenant = new Tenant();
                tenant.UserId = user.Id;
                _cx.Add(tenant);

                await _cx.SaveChangesAsync();

                await _cx.Database.CommitTransactionAsync();

                return true;
            }
            catch
            {
                if(_cx.Database.CurrentTransaction != null)
                    await _cx.Database.CurrentTransaction.RollbackAsync();
                throw;
            }
        }
    }
}
