﻿using CursoApi.Dtos;
using CursoApi.Models;
using Microsoft.EntityFrameworkCore;

namespace CursoApi.Services
{
    public class RuralPropertyService : IRuralPropertyService
    {
        ApplicationContext _cx;
        ITenantService _tenantService;

        public RuralPropertyService(ApplicationContext cx, ITenantService tenantService)
        {
            _cx = cx;
            _tenantService = tenantService;
        }

        public async Task<IList<RuralPropertyDto>> List()
        {
            return await _cx.RuralProperties
                .Select(x => new RuralPropertyDto()
                {
                    Id = x.Id,
                    Name = x.Name,
                    Ibge = x.Ibge,
                    Size = x.Size,
                    TenantId = x.TenantId
                })
                .ToListAsync();
        }

        public async Task<RuralPropertyDto> Insert(RuralPropertyDto dto)
        {
            RuralProperty property = new RuralProperty()
            {
                Ibge = dto.Ibge,
                Name = dto.Name,
                Size = dto.Size,
                TenantId = _tenantService.TenantId
            };

            _cx.Add(property);
            await _cx.SaveChangesAsync();

            return await Get(property.Id);
        }

        public async Task Edit(RuralPropertyDto dto)
        {
            var property = _cx.RuralProperties.Single(x => x.Id == dto.Id);

            property.Ibge = dto.Ibge;
            property.Name = dto.Name;
            property.Size = dto.Size;

            await _cx.SaveChangesAsync();
        }

        public async Task Delete(int id)
        {
            var property = await _cx.RuralProperties
                .SingleAsync(x => x.Id == id);

            _cx.Remove(property);
            await _cx.SaveChangesAsync();
        }

        public async Task<RuralPropertyDto?> Get(int id)
        {
            return await _cx.RuralProperties
                .Select(x => new RuralPropertyDto()
                {
                    Id = x.Id,
                    Name = x.Name,
                    Ibge = x.Ibge,
                    Size = x.Size,
                    TenantId = x.TenantId
                })
                .AsNoTracking()
                .FirstOrDefaultAsync(x => x.Id == id);
        }
    }
}
