﻿using CursoApi.Dtos;
using CursoApi.Models;
using Microsoft.AspNetCore.Identity;
using Microsoft.IdentityModel.Tokens;
using System.IdentityModel.Tokens.Jwt;
using System.Security.Claims;
using System.Text;

namespace CursoApi.Services
{
    public class AuthService : IAuthService
    {
        UserManager<IdentityUser> _userManager;
        SignInManager<IdentityUser> _signInManager;
        ApplicationContext _cx;

        public AuthService(UserManager<IdentityUser> userManager,
            SignInManager<IdentityUser> signInManager,
            ApplicationContext cx)
        {
            _userManager = userManager;
            _signInManager = signInManager;
            _cx = cx;
        }

        public async Task<string> Authenticate(AuthDto dto)
        {
            var result = await _signInManager.PasswordSignInAsync(dto.UserName, dto.Password, false, false);

            if (result.Succeeded)
            {
                var user = _signInManager.UserManager.Users
                    .First(x => x.UserName == dto.UserName);
                var tenant = _cx.Tenants.First(x => x.UserId == user.Id);
                
                return Token(tenant.Id);
            }

            return "";
        }

        private string Token(int tenantId)
        {
            var key = "here goes the secret key...";

            var securityKey = 
                new SymmetricSecurityKey(Encoding.ASCII.GetBytes(key));

            var signingCredential = 
                new SigningCredentials(securityKey, 
                SecurityAlgorithms.HmacSha256Signature);

            var claims = new List<Claim>()
            {
                new Claim("tenantId", $"{tenantId}")
            };

            var token = new JwtSecurityToken(
                issuer: "cursoapi.com.br",
                audience: "cursoapi",
                claims: claims,
                expires: DateTime.UtcNow.AddDays(2),
                signingCredentials: signingCredential
                );

            return new JwtSecurityTokenHandler().WriteToken(token);
        }
    }
}
