﻿using CursoApi.Dtos;
using CursoApi.Services;
using Microsoft.AspNetCore.Mvc;

namespace CursoApi.Controllers
{
    [Route("auth")]
    [ApiController]
    public class AuthController : ControllerBase
    {
        IAuthService _service;

        public AuthController(IAuthService service)
        {
            _service = service;
        }

        /// <summary>
        /// Realiza a autenticação de um usuário.
        /// </summary>
        /// <param name="dto"></param>
        /// <returns>JSON Web Token</returns>
        [HttpPost]
        [ProducesResponseType(StatusCodes.Status200OK)]
        [ProducesResponseType(StatusCodes.Status401Unauthorized)]
        public async Task<ActionResult<string>> Post(AuthDto dto)
        {
            var token = await _service.Authenticate(dto);

            if (string.IsNullOrEmpty(token))
                return Unauthorized();

            return token;
        }
    }
}
