﻿namespace CursoApi.Services
{
    public class TenantService : ITenantService
    {
        IHttpContextAccessor _http;

        public TenantService(IHttpContextAccessor http)
        {
            _http = http;
        }

        public int TenantId
        {
            get
            {
                var tenant = _http.HttpContext?.User?.Claims?.Where(x => x.Type == "tenantId")?.FirstOrDefault()?.Value ?? "0";
                return int.Parse(tenant);
            }
        }
    }
}
