﻿using CursoApi.Services;
using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore;

namespace CursoApi.Models
{
    public class ApplicationContext : IdentityDbContext
    {
        public DbSet<RuralProperty> RuralProperties { get; set; }
        public DbSet<Tenant> Tenants { get; set; }

        int? TenantId { get; set; }

        public ApplicationContext(ITenantService user)
        {
            TenantId = user.TenantId;
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
            => optionsBuilder.UseNpgsql("Host=cursoapi-db;Database=cursoapi;Username=postgres;Password=123456")
            .EnableSensitiveDataLogging();

        protected override void OnModelCreating(ModelBuilder builder)
        {
            base.OnModelCreating(builder);

            builder.Entity<RuralProperty>(b =>
            {
                b.HasQueryFilter(x => x.TenantId == TenantId);
            });
        }
    }
}
