﻿using CursoApi.Dtos;
using CursoApi.Services;
using Microsoft.AspNetCore.Mvc;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace CursoApi.Controllers
{
    [Route("users")]
    [ApiController]
    public class UsersController : ControllerBase
    {
        IUserService _user;

        public UsersController(IUserService user)
        {
            _user = user;
        }

        /// <summary>
        /// Insere um novo usuário no banco.
        /// </summary>
        /// <param name="dto"></param>
        /// <returns></returns>
        [HttpPost]
        [ProducesResponseType(StatusCodes.Status204NoContent)]
        [ProducesResponseType(StatusCodes.Status400BadRequest)]
        public async Task<IActionResult> Post(UserDto dto)
        {
            var result = await _user.Insert(dto);
            return result ? NoContent() : BadRequest();
        }
    }
}
